/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.AccessTokenResponse;

abstract class AbstractKeycloakIntegrationIndexingServiceIT {
    @ConfigProperty(name="quarkus.oidc.auth-server-url")
    String keycloakURL;

    AbstractKeycloakIntegrationIndexingServiceIT() {
    }

    @Test
    void testUnauthorizedUserAccess() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id } }\" }").auth().oauth2(this.getAccessToken("alice")).when().get("/graphql", new Object[0])).then()).statusCode(403);
    }

    @Test
    void testNoTokenProvided() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id } }\" }").when().get("/graphql", new Object[0])).then()).statusCode(401);
    }

    @Test
    void testAuthorizedUserProvided() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("jdoe")).contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200);
    }

    @Test
    void graphiqlLoginOnKeycloakServedTest() {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/graphiql/", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/", new Object[0])).then()).statusCode(200);
        this.assertIsLoginPage((Response)RestAssured.given().when().get("/graphiql/", new Object[0]));
        this.assertIsLoginPage((Response)RestAssured.given().when().get("/", new Object[0]));
        this.assertIsNotLoginPage((Response)RestAssured.given().when().get("/other", new Object[0]));
        this.assertIsNotLoginPage((Response)RestAssured.given().when().get("/graphql", new Object[0]));
    }

    private void assertIsLoginPage(Response response) {
        Assertions.assertThat((String)((Response)response.andReturn()).body().asString()).contains(new CharSequence[]{"<title>Log in to kogito</title>"});
    }

    private void assertIsNotLoginPage(Response response) {
        Assertions.assertThat((String)((Response)response.andReturn()).body().asString()).doesNotContain(new CharSequence[]{"<title>Log in to kogito</title>"});
    }

    private String getAccessToken(String userName) {
        return ((AccessTokenResponse)((Response)RestAssured.given().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userName}).param("client_id", new Object[]{"kogito-app"}).param("client_secret", new Object[]{"secret"}).when().post(this.keycloakURL + "/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }
}

