/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.auth;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.auth.MultiTenantResolver;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class MultiTenantResolverTest {
    private static final String GRAPH_UI_PATH = System.getProperty("kogito.data-index.vertx-graphql.ui.path", "/graphiql");
    private static final String GRAPH_UI_TENANT = System.getProperty("kogito.data-index.vertx-graphql.ui.tenant", "web-app-tenant");
    @Mock
    RoutingContext routingContextMock;
    @Mock
    HttpServerRequest requestMock;
    @InjectMocks
    MultiTenantResolver multiTenantResolver;

    MultiTenantResolverTest() {
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.routingContextMock.request()).thenReturn((Object)this.requestMock);
        this.givenTenantIsConfigured();
    }

    @Test
    void resolveGraphiqlTenantTest() {
        Mockito.when((Object)this.requestMock.path()).thenReturn((Object)GRAPH_UI_PATH);
        Assertions.assertThat((String)this.multiTenantResolver.resolve(this.routingContextMock)).isEqualTo(GRAPH_UI_TENANT);
    }

    @Test
    void resolveGraphiqlTenantRootTest() {
        Mockito.when((Object)this.requestMock.path()).thenReturn((Object)"/");
        Assertions.assertThat((String)this.multiTenantResolver.resolve(this.routingContextMock)).isEqualTo(GRAPH_UI_TENANT);
    }

    @Test
    void resolveGraphqlTenantTest() {
        Mockito.when((Object)this.requestMock.path()).thenReturn((Object)"/graphql");
        Assertions.assertThat((String)this.multiTenantResolver.resolve(this.routingContextMock)).isNull();
    }

    @Test
    void resolveGraphUITenantTest() {
        this.multiTenantResolver.graphUIPath = "/graphiql";
        Mockito.when((Object)this.requestMock.path()).thenReturn((Object)"/graphiql/");
        Assertions.assertThat((String)this.multiTenantResolver.resolve(this.routingContextMock)).isEqualTo(GRAPH_UI_TENANT);
    }

    @Test
    void resolveOtherPathTest() {
        Mockito.when((Object)this.requestMock.path()).thenReturn((Object)"/other");
        Assertions.assertThat((String)this.multiTenantResolver.resolve(this.routingContextMock)).isNull();
    }

    private void givenTenantIsConfigured() {
        this.multiTenantResolver.graphUITenantId = GRAPH_UI_TENANT;
        this.multiTenantResolver.graphUIPath = GRAPH_UI_PATH;
    }
}

