/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.json;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import net.javacrumbs.jsonunit.assertj.JsonAssertion;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.json.UserTaskInstanceMetaMapper;
import org.kie.kogito.index.model.UserTaskInstance;

public class UserTaskInstanceMetaMapperTest {
    @Test
    public void testUserTaskInstanceMapper() {
        String taskId = UUID.randomUUID().toString();
        String processId = "travels";
        String rootProcessId = "root_travels";
        String processInstanceId = UUID.randomUUID().toString();
        String rootProcessInstanceId = UUID.randomUUID().toString();
        String utPrefix = "metadata.userTasks";
        KogitoUserTaskCloudEvent event = TestUtils.getUserTaskCloudEvent(taskId, processId, processInstanceId, rootProcessInstanceId, rootProcessId, "InProgress");
        ObjectNode json = new UserTaskInstanceMetaMapper().apply(event);
        Assertions.assertThat((Iterable)json).isNotNull();
        JsonAssertions.assertThatJson((Object)json.toString()).and(new JsonAssertion[]{a -> a.node("id").isEqualTo((Object)rootProcessInstanceId), a -> a.node("processId").isEqualTo((Object)rootProcessId), a -> a.node("metadata").isNotNull(), a -> a.node("metadata.lastUpdate").isEqualTo((Object)event.getTime().toInstant().toEpochMilli()), a -> a.node(utPrefix).isArray().hasSize(1), a -> a.node(utPrefix + "[0].id").isEqualTo((Object)taskId), a -> a.node(utPrefix + "[0].processInstanceId").isEqualTo((Object)processInstanceId), a -> a.node(utPrefix + "[0].state").isEqualTo((Object)((UserTaskInstance)event.getData()).getState()), a -> a.node(utPrefix + "[0].description").isEqualTo((Object)((UserTaskInstance)event.getData()).getDescription()), a -> a.node(utPrefix + "[0].name").isEqualTo((Object)((UserTaskInstance)event.getData()).getName()), a -> a.node(utPrefix + "[0].priority").isEqualTo((Object)((UserTaskInstance)event.getData()).getPriority()), a -> a.node(utPrefix + "[0].actualOwner").isEqualTo((Object)((UserTaskInstance)event.getData()).getActualOwner()), a -> a.node(utPrefix + "[0].adminUsers[0]").isEqualTo(((UserTaskInstance)event.getData()).getAdminUsers().stream().findFirst().get()), a -> a.node(utPrefix + "[0].adminGroups[0]").isEqualTo(((UserTaskInstance)event.getData()).getAdminGroups().stream().findFirst().get()), a -> a.node(utPrefix + "[0].excludedUsers[0]").isEqualTo(((UserTaskInstance)event.getData()).getExcludedUsers().stream().findFirst().get()), a -> a.node(utPrefix + "[0].potentialGroups[0]").isEqualTo(((UserTaskInstance)event.getData()).getPotentialGroups().stream().findFirst().get()), a -> a.node(utPrefix + "[0].potentialUsers[0]").isEqualTo(((UserTaskInstance)event.getData()).getPotentialUsers().stream().findFirst().get()), a -> a.node(utPrefix + "[0].started").isEqualTo((Object)((UserTaskInstance)event.getData()).getStarted().toInstant().toEpochMilli()), a -> a.node(utPrefix + "[0].completed").isEqualTo((Object)((UserTaskInstance)event.getData()).getCompleted().toInstant().toEpochMilli()), a -> a.node(utPrefix + "[0].lastUpdate").isEqualTo((Object)((UserTaskInstance)event.getData()).getLastUpdate().toInstant().toEpochMilli())});
    }
}

