/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.vertx;

import graphql.GraphQL;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.graphql.GraphiQLHandler;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.index.vertx.VertxRouterSetup;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class VertxRouterSetupTest {
    @Mock
    Router routerMock;
    @Mock
    Route routeMock;
    @Mock
    RoutingContext routingContextMock;
    @Mock
    GraphQL graphQLMock;
    @InjectMocks
    @Spy
    VertxRouterSetup vertxRouterSetup;

    @BeforeEach
    public void setup() {
        Mockito.lenient().when((Object)this.routerMock.route()).thenReturn((Object)this.routeMock);
        Mockito.lenient().when((Object)this.routerMock.route(ArgumentMatchers.anyString())).thenReturn((Object)this.routeMock);
    }

    @Test
    public void testAuthEnabledTrue() {
        this.vertxRouterSetup.authEnabled = true;
        this.vertxRouterSetup.graphUIPath = "/graphiql";
        this.vertxRouterSetup.setupRouter(this.routerMock);
        ((VertxRouterSetup)Mockito.verify((Object)this.vertxRouterSetup)).addGraphiqlRequestHeader((GraphiQLHandler)ArgumentMatchers.any());
    }

    @Test
    public void testAuthEnabledFalse() {
        this.vertxRouterSetup.authEnabled = false;
        this.vertxRouterSetup.graphUIPath = "/graphiql";
        this.vertxRouterSetup.setupRouter(this.routerMock);
        ((VertxRouterSetup)Mockito.verify((Object)this.vertxRouterSetup, (VerificationMode)Mockito.never())).addGraphiqlRequestHeader((GraphiQLHandler)ArgumentMatchers.any());
    }

    @Test
    public void testAddGraphiqlRequestHeader() {
        GraphiQLHandler graphiQLHandlerMock = (GraphiQLHandler)Mockito.mock(GraphiQLHandler.class);
        String token = "TEST_TOKEN";
        QuarkusHttpUser quarkusHttpUser = (QuarkusHttpUser)Mockito.mock(QuarkusHttpUser.class);
        SecurityIdentity securityIdentity = (SecurityIdentity)Mockito.mock(SecurityIdentity.class);
        AccessTokenCredential accessTokenCredential = (AccessTokenCredential)Mockito.mock(AccessTokenCredential.class);
        Mockito.when((Object)this.routingContextMock.user()).thenReturn((Object)quarkusHttpUser);
        Mockito.when((Object)quarkusHttpUser.getSecurityIdentity()).thenReturn((Object)securityIdentity);
        Mockito.when((Object)((AccessTokenCredential)securityIdentity.getCredential(AccessTokenCredential.class))).thenReturn((Object)accessTokenCredential);
        Mockito.when((Object)accessTokenCredential.getToken()).thenReturn((Object)token);
        this.vertxRouterSetup.addGraphiqlRequestHeader(graphiQLHandlerMock);
        ArgumentCaptor functionCaptor = ArgumentCaptor.forClass(Function.class);
        ((GraphiQLHandler)Mockito.verify((Object)graphiQLHandlerMock)).graphiQLRequestHeaders((Function)functionCaptor.capture());
        CaseInsensitiveHeaders headers = (CaseInsensitiveHeaders)((Function)functionCaptor.getValue()).apply(this.routingContextMock);
        Assertions.assertThat((String)headers.get(HttpHeaders.AUTHORIZATION)).isEqualTo("Bearer " + token);
    }
}

