/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.index.DataIndexStorageService;
import org.kie.kogito.index.api.KogitoRuntimeClient;
import org.kie.kogito.index.graphql.query.GraphQLQueryOrderByParser;
import org.kie.kogito.index.graphql.query.GraphQLQueryParserRegistry;
import org.kie.kogito.index.json.DataIndexParsingException;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.Node;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GraphQLSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLSchemaManager.class);
    private static final String PROCESS_INSTANCE_ADDED = "ProcessInstanceAdded";
    private static final String PROCESS_INSTANCE_UPDATED = "ProcessInstanceUpdated";
    private static final String USER_TASK_INSTANCE_ADDED = "UserTaskInstanceAdded";
    private static final String USER_TASK_INSTANCE_UPDATED = "UserTaskInstanceUpdated";
    private static final String JOB_UPDATED = "JobUpdated";
    private static final String JOB_ADDED = "JobAdded";
    @Inject
    DataIndexStorageService cacheService;
    @Inject
    GraphQLScalarType qlDateTimeScalarType;
    @Inject
    KogitoRuntimeClient dataIndexApiExecutor;
    private GraphQLSchema schema;

    @PostConstruct
    public void setup() {
        this.schema = this.createSchema();
        GraphQLQueryParserRegistry.get().registerParsers((GraphQLInputObjectType)this.schema.getType("ProcessInstanceArgument"), (GraphQLInputObjectType)this.schema.getType("UserTaskInstanceArgument"), (GraphQLInputObjectType)this.schema.getType("JobArgument"), (GraphQLInputObjectType)this.schema.getType("KogitoMetadataArgument"));
    }

    private GraphQLSchema createSchema() {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("schema.graphqls");
        SchemaParser schemaParser = new SchemaParser();
        TypeDefinitionRegistry typeDefinitionRegistry = schemaParser.parse((Reader)new InputStreamReader(stream));
        RuntimeWiring runtimeWiring = RuntimeWiring.newRuntimeWiring().type("Query", builder -> {
            builder.dataFetcher("ProcessInstances", this::getProcessInstancesValues);
            builder.dataFetcher("UserTaskInstances", this::getUserTaskInstancesValues);
            builder.dataFetcher("Jobs", this::getJobsValues);
            return builder;
        }).type("Mutation", builder -> {
            builder.dataFetcher("ProcessInstanceAbort", this::abortProcessInstance);
            builder.dataFetcher("ProcessInstanceRetry", this::retryProcessInstance);
            builder.dataFetcher("ProcessInstanceSkip", this::skipProcessInstance);
            return builder;
        }).type("ProcessInstance", builder -> {
            builder.dataFetcher("parentProcessInstance", this::getParentProcessInstanceValue);
            builder.dataFetcher("childProcessInstances", this::getChildProcessInstancesValues);
            builder.dataFetcher("serviceUrl", this::getProcessInstanceServiceUrl);
            builder.dataFetcher("diagram", this::getProcessInstanceDiagram);
            builder.dataFetcher("nodeDefinitions", this::getProcessNodes);
            return builder;
        }).type("ProcessInstanceMeta", builder -> {
            builder.dataFetcher("serviceUrl", this::getProcessInstanceJsonServiceUrl);
            return builder;
        }).type("ProcessInstanceState", builder -> {
            builder.enumValues(name -> ProcessInstanceState.valueOf((String)name).ordinal());
            return builder;
        }).type("Subscription", builder -> {
            builder.dataFetcher(PROCESS_INSTANCE_ADDED, this.getProcessInstanceAddedDataFetcher());
            builder.dataFetcher(PROCESS_INSTANCE_UPDATED, this.getProcessInstanceUpdatedDataFetcher());
            builder.dataFetcher(USER_TASK_INSTANCE_ADDED, this.getUserTaskInstanceAddedDataFetcher());
            builder.dataFetcher(USER_TASK_INSTANCE_UPDATED, this.getUserTaskInstanceUpdatedDataFetcher());
            builder.dataFetcher(JOB_ADDED, this.getJobAddedDataFetcher());
            builder.dataFetcher(JOB_UPDATED, this.getJobUpdatedDataFetcher());
            return builder;
        }).scalar(this.qlDateTimeScalarType).build();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        return schemaGenerator.makeExecutableSchema(typeDefinitionRegistry, runtimeWiring);
    }

    public CompletableFuture<String> abortProcessInstance(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)this.cacheService.getProcessInstancesCache().get((Object)((String)env.getArgument("id")));
        return this.dataIndexApiExecutor.abortProcessInstance(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance);
    }

    public CompletableFuture<String> retryProcessInstance(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)this.cacheService.getProcessInstancesCache().get((Object)((String)env.getArgument("id")));
        return this.dataIndexApiExecutor.retryProcessInstance(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance);
    }

    public CompletableFuture<String> skipProcessInstance(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)this.cacheService.getProcessInstancesCache().get((Object)((String)env.getArgument("id")));
        return this.dataIndexApiExecutor.skipProcessInstance(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance);
    }

    public CompletableFuture getProcessInstanceDiagram(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)env.getSource();
        return this.dataIndexApiExecutor.getProcessInstanceDiagram(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance);
    }

    public CompletableFuture<List<Node>> getProcessNodes(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)env.getSource();
        return this.dataIndexApiExecutor.getProcessInstanceNodeDefinitions(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance);
    }

    protected String getProcessInstanceServiceUrl(DataFetchingEnvironment env) {
        ProcessInstance source = (ProcessInstance)env.getSource();
        if (source == null || source.getEndpoint() == null || source.getProcessId() == null) {
            return null;
        }
        return this.getServiceUrl(source.getEndpoint(), source.getProcessId());
    }

    protected String getProcessInstanceJsonServiceUrl(DataFetchingEnvironment env) {
        Object source = env.getSource();
        if (source != null && source instanceof JsonNode) {
            String endpoint = ((JsonNode)source).get("endpoint").asText();
            String processId = ((JsonNode)source).get("processId").asText();
            return this.getServiceUrl(endpoint, processId);
        }
        return null;
    }

    private String getServiceUrl(String endpoint, String processId) {
        LOGGER.debug("Process endpoint {}", (Object)endpoint);
        if (endpoint.startsWith("/")) {
            LOGGER.warn("Process '{}' endpoint '{}', does not contain full URL, please review the kogito.service.url system property to point the public URL for this runtime.", (Object)processId, (Object)endpoint);
        }
        String context = this.getContext(processId);
        LOGGER.debug("Process context {}", (Object)context);
        if (context.equals(endpoint) || endpoint.equals("/" + context)) {
            return null;
        }
        return endpoint.contains("/" + context) ? endpoint.substring(0, endpoint.lastIndexOf("/" + context)) : null;
    }

    private String getContext(String processId) {
        return processId.contains(".") ? processId.substring(processId.lastIndexOf(46) + 1) : processId;
    }

    private Collection<ProcessInstance> getChildProcessInstancesValues(DataFetchingEnvironment env) {
        ProcessInstance source = (ProcessInstance)env.getSource();
        Query query = this.cacheService.getProcessInstancesCache().query();
        query.filter(Collections.singletonList(QueryFilterFactory.equalTo((String)"parentProcessInstanceId", (Object)source.getId())));
        return query.execute();
    }

    private ProcessInstance getParentProcessInstanceValue(DataFetchingEnvironment env) {
        ProcessInstance source = (ProcessInstance)env.getSource();
        if (source.getParentProcessInstanceId() == null) {
            return null;
        }
        Query query = this.cacheService.getProcessInstancesCache().query();
        query.filter(Collections.singletonList(QueryFilterFactory.equalTo((String)"id", (Object)source.getParentProcessInstanceId())));
        List execute = query.execute();
        return execute.size() > 0 ? (ProcessInstance)execute.get(0) : null;
    }

    private Collection<ProcessInstance> getProcessInstancesValues(DataFetchingEnvironment env) {
        return this.executeAdvancedQueryForCache(this.cacheService.getProcessInstancesCache(), env);
    }

    private Collection<Job> getJobsValues(DataFetchingEnvironment env) {
        return this.executeAdvancedQueryForCache(this.cacheService.getJobsCache(), env);
    }

    private <T> List<T> executeAdvancedQueryForCache(Storage<String, T> cache, DataFetchingEnvironment env) {
        Objects.requireNonNull(cache, "Cache not found");
        String inputTypeName = ((GraphQLNamedType)env.getFieldDefinition().getArgument("where").getType()).getName();
        Query query = cache.query();
        Map where = (Map)env.getArgument("where");
        query.filter((List)GraphQLQueryParserRegistry.get().getParser(inputTypeName).apply(where));
        query.sort(new GraphQLQueryOrderByParser().apply(env));
        Map pagination = (Map)env.getArgument("pagination");
        if (pagination != null) {
            Integer offset;
            Integer limit = (Integer)pagination.get("limit");
            if (limit != null) {
                query.limit(limit);
            }
            if ((offset = (Integer)pagination.get("offset")) != null) {
                query.offset(offset);
            }
        }
        return query.execute();
    }

    private Collection<UserTaskInstance> getUserTaskInstancesValues(DataFetchingEnvironment env) {
        return this.executeAdvancedQueryForCache(this.cacheService.getUserTaskInstancesCache(), env);
    }

    private DataFetcher<Publisher<ObjectNode>> getProcessInstanceAddedDataFetcher() {
        return this.objectCreatedPublisher(() -> this.cacheService.getProcessInstancesCache());
    }

    private DataFetcher<Publisher<ObjectNode>> getProcessInstanceUpdatedDataFetcher() {
        return this.objectUpdatedPublisher(() -> this.cacheService.getProcessInstancesCache());
    }

    private DataFetcher<Publisher<ObjectNode>> getUserTaskInstanceAddedDataFetcher() {
        return this.objectCreatedPublisher(() -> this.cacheService.getUserTaskInstancesCache());
    }

    private DataFetcher<Publisher<ObjectNode>> getUserTaskInstanceUpdatedDataFetcher() {
        return this.objectUpdatedPublisher(() -> this.cacheService.getUserTaskInstancesCache());
    }

    private DataFetcher<Publisher<ObjectNode>> getJobUpdatedDataFetcher() {
        return this.objectUpdatedPublisher(() -> this.cacheService.getJobsCache());
    }

    private DataFetcher<Publisher<ObjectNode>> getJobAddedDataFetcher() {
        return this.objectCreatedPublisher(() -> this.cacheService.getJobsCache());
    }

    private DataFetcher<Publisher<ObjectNode>> objectCreatedPublisher(Supplier<Storage> cache) {
        return env -> ((Storage)cache.get()).objectCreatedListener();
    }

    private DataFetcher<Publisher<ObjectNode>> objectUpdatedPublisher(Supplier<Storage> cache) {
        return env -> ((Storage)cache.get()).objectUpdatedListener();
    }

    protected DataFetcher<Publisher<ObjectNode>> getDomainModelUpdatedDataFetcher(String processId) {
        return env -> this.cacheService.getDomainModelCache(processId).objectUpdatedListener();
    }

    protected DataFetcher<Publisher<ObjectNode>> getDomainModelAddedDataFetcher(String processId) {
        return env -> this.cacheService.getDomainModelCache(processId).objectCreatedListener();
    }

    protected DataFetcher<Collection<ObjectNode>> getDomainModelDataFetcher(String processId) {
        return env -> {
            List result = this.executeAdvancedQueryForCache(this.cacheService.getDomainModelCache(processId), env);
            return result.stream().map(json -> {
                try {
                    return (ObjectNode)JsonUtils.getObjectMapper().readTree(json.toString());
                }
                catch (IOException e) {
                    throw new DataIndexParsingException("Failed to parse JSON: " + e.getMessage(), e);
                }
            }).collect(Collectors.toList());
        };
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.schema;
    }

    public void transform(Consumer<GraphQLSchema.Builder> builder) {
        this.schema = this.schema.transform(builder);
    }

    public void setDataIndexApiExecutor(KogitoRuntimeClient dataIndexApiExecutor) {
        this.dataIndexApiExecutor = dataIndexApiExecutor;
    }
}

