/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.function.Function;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.ProcessInstance;

public class ProcessInstanceMetaMapper
implements Function<KogitoProcessCloudEvent, ObjectNode> {
    @Override
    public ObjectNode apply(KogitoProcessCloudEvent event) {
        if (event == null) {
            return null;
        }
        ProcessInstance pi = (ProcessInstance)event.getData();
        ObjectNode json = JsonUtils.getObjectMapper().createObjectNode();
        json.put("id", event.getRootProcessInstanceId() == null ? event.getProcessInstanceId() : event.getRootProcessInstanceId());
        json.put("processId", event.getRootProcessId() == null ? event.getProcessId() : event.getRootProcessId());
        ObjectNode kogito = JsonUtils.getObjectMapper().createObjectNode();
        kogito.put("lastUpdate", event.getTime().toInstant().toEpochMilli());
        kogito.withArray("processInstances").add((JsonNode)this.getProcessJson(event, pi));
        json.set("metadata", (JsonNode)kogito);
        json.setAll(((ProcessInstance)event.getData()).getVariables());
        return json;
    }

    private ObjectNode getProcessJson(KogitoProcessCloudEvent event, ProcessInstance pi) {
        ObjectNode json = JsonUtils.getObjectMapper().createObjectNode();
        json.put("id", pi.getId());
        json.put("processId", pi.getProcessId());
        json.put("processName", pi.getProcessName());
        if (pi.getRootProcessInstanceId() != null) {
            json.put("rootProcessInstanceId", pi.getRootProcessInstanceId());
        }
        if (pi.getParentProcessInstanceId() != null) {
            json.put("parentProcessInstanceId", pi.getParentProcessInstanceId());
        }
        if (pi.getRootProcessId() != null) {
            json.put("rootProcessId", pi.getRootProcessId());
        }
        json.put("state", pi.getState());
        if (event.getSource() != null) {
            json.put("endpoint", event.getSource().toString());
        }
        if (pi.getStart() != null) {
            json.put("start", pi.getStart().toInstant().toEpochMilli());
        }
        if (pi.getEnd() != null) {
            json.put("end", pi.getEnd().toInstant().toEpochMilli());
        }
        if (pi.getLastUpdate() != null) {
            json.put("lastUpdate", pi.getLastUpdate().toInstant().toEpochMilli());
        }
        if (pi.getBusinessKey() != null) {
            json.put("businessKey", pi.getBusinessKey());
        }
        return json;
    }
}

