/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInputObjectTypeMapper
implements Function<GraphQLObjectType, GraphQLInputObjectType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInputObjectTypeMapper.class);
    private GraphQLSchema schema;
    private Map<String, GraphQLType> additionalTypes;

    public AbstractInputObjectTypeMapper(GraphQLSchema schema, Map<String, GraphQLType> additionalTypes) {
        this.schema = schema;
        this.additionalTypes = additionalTypes;
    }

    @Override
    public GraphQLInputObjectType apply(GraphQLObjectType domain) {
        LOGGER.debug("GraphQL mapping order by for: {}", (Object)domain.getName());
        String typeName = this.getTypeName(domain);
        GraphQLInputObjectType existingType = this.getInputObjectType(typeName);
        if (existingType == null) {
            GraphQLInputObjectType.Builder builder2 = GraphQLInputObjectType.newInputObject().name(typeName);
            this.build(domain).accept(builder2);
            return builder2.build();
        }
        return existingType.transform(builder -> {
            builder.clearFields();
            this.build(domain).accept((GraphQLInputObjectType.Builder)builder);
        });
    }

    protected abstract Consumer<GraphQLInputObjectType.Builder> build(GraphQLObjectType var1);

    protected abstract String getTypeName(GraphQLObjectType var1);

    protected GraphQLSchema getSchema() {
        return this.schema;
    }

    protected Map<String, GraphQLType> getAdditionalTypes() {
        return this.additionalTypes;
    }

    protected GraphQLInputObjectType getInputObjectType(String name) {
        return (GraphQLInputObjectType)this.schema.getType(name);
    }

    protected String resolveBaseTypeName(GraphQLOutputType graphQLOutputType) {
        if (graphQLOutputType instanceof GraphQLList) {
            String baseType = ((GraphQLNamedType)graphQLOutputType.getChildren().get(0)).getName();
            if ("String".equals(baseType)) {
                return "StringArray";
            }
            return baseType;
        }
        return ((GraphQLNamedType)graphQLOutputType).getName();
    }
}

