/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.kie.kogito.index.model.KogitoMetadata;
import org.kie.kogito.persistence.api.proto.AttributeDescriptor;
import org.kie.kogito.persistence.api.proto.DomainDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLObjectTypeMapper
implements Function<DomainDescriptor, GraphQLObjectType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLObjectTypeMapper.class);
    private GraphQLSchema schema;
    private Map<String, GraphQLType> additionalTypes;
    private Map<String, DomainDescriptor> allTypes;

    public GraphQLObjectTypeMapper(GraphQLSchema schema, Map<String, GraphQLType> additionalTypes, Map<String, DomainDescriptor> allTypes) {
        this.schema = schema;
        this.additionalTypes = additionalTypes;
        this.allTypes = allTypes;
    }

    public static String getTypeName(String type) {
        return type.contains(".") ? type.substring(type.lastIndexOf(46) + 1) : type;
    }

    @Override
    public GraphQLObjectType apply(DomainDescriptor domain) {
        LOGGER.debug("GraphQL mapping domain: {}", (Object)domain);
        String typeName = GraphQLObjectTypeMapper.getTypeName(domain.getTypeName());
        GraphQLObjectType existingType = (GraphQLObjectType)this.schema.getType(typeName);
        if (existingType == null) {
            GraphQLObjectType.Builder builder2 = GraphQLObjectType.newObject().name(typeName);
            this.build(domain).accept(builder2);
            return builder2.build();
        }
        return existingType.transform(builder -> {
            builder.clearFields();
            this.build(domain).accept((GraphQLObjectType.Builder)builder);
        });
    }

    private Consumer<GraphQLObjectType.Builder> build(DomainDescriptor domain) {
        return builder -> domain.getAttributes().forEach(field -> {
            LOGGER.debug("GraphQL mapping field: {}", (Object)field.getName());
            if (KogitoMetadata.class.getName().equals(field.getTypeName())) {
                builder.field(GraphQLFieldDefinition.newFieldDefinition().name("metadata").type((GraphQLOutputType)this.schema.getObjectType("KogitoMetadata"))).build();
            } else {
                GraphQLScalarType type;
                switch (field.getTypeName()) {
                    case "java.lang.Integer": {
                        type = Scalars.GraphQLInt;
                        break;
                    }
                    case "java.lang.Long": {
                        type = ExtendedScalars.GraphQLLong;
                        break;
                    }
                    case "java.lang.String": 
                    case "java.util.Date": {
                        type = Scalars.GraphQLString;
                        break;
                    }
                    case "java.lang.Boolean": {
                        type = Scalars.GraphQLBoolean;
                        break;
                    }
                    default: {
                        type = this.getGraphQLType((AttributeDescriptor)field, this.schema, this.additionalTypes, this.allTypes);
                    }
                }
                if (type != null) {
                    if (field.getLabel() != null && field.getLabel().contains("REPEATED")) {
                        GraphQLList listOfType = new GraphQLList((GraphQLType)type);
                        builder.field(GraphQLFieldDefinition.newFieldDefinition().name(field.getName()).type((GraphQLOutputType)listOfType));
                    } else {
                        builder.field(GraphQLFieldDefinition.newFieldDefinition().name(field.getName()).type((GraphQLOutputType)type));
                    }
                }
            }
        });
    }

    private GraphQLOutputType getGraphQLType(AttributeDescriptor attribute, GraphQLSchema schema, Map<String, GraphQLType> additionalTypes, Map<String, DomainDescriptor> allTypes) {
        String typeName = GraphQLObjectTypeMapper.getTypeName(attribute.getTypeName());
        GraphQLType type = schema.getType(typeName);
        if (type == null) {
            if (!additionalTypes.containsKey(typeName)) {
                DomainDescriptor domain = allTypes.get(typeName);
                if (domain != null) {
                    type = new GraphQLObjectTypeMapper(schema, additionalTypes, allTypes).apply(domain);
                    if (type != null) {
                        additionalTypes.put(typeName, type);
                    } else {
                        LOGGER.warn("GraphQL type mapping returned null for the typeName: {}", (Object)typeName);
                    }
                }
            } else {
                type = additionalTypes.get(typeName);
            }
        }
        return (GraphQLOutputType)type;
    }
}

