/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.util.function.Function;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceEventBody;
import org.kie.kogito.index.json.JsonUtils;

public class ProcessInstanceMetaMapper
implements Function<ProcessInstanceDataEvent, ObjectNode> {
    @Override
    public ObjectNode apply(ProcessInstanceDataEvent event) {
        if (event == null) {
            return null;
        }
        ObjectNode json = JsonUtils.getObjectMapper().createObjectNode();
        json.put("id", Strings.isNullOrEmpty((String)((ProcessInstanceEventBody)event.getData()).getRootInstanceId()) ? ((ProcessInstanceEventBody)event.getData()).getId() : ((ProcessInstanceEventBody)event.getData()).getRootInstanceId());
        json.put("processId", Strings.isNullOrEmpty((String)((ProcessInstanceEventBody)event.getData()).getRootProcessId()) ? ((ProcessInstanceEventBody)event.getData()).getProcessId() : ((ProcessInstanceEventBody)event.getData()).getRootProcessId());
        ObjectNode kogito = JsonUtils.getObjectMapper().createObjectNode();
        kogito.put("lastUpdate", event.getTime().toInstant().toEpochMilli());
        kogito.withArray("processInstances").add((JsonNode)this.getProcessJson(event));
        json.set("metadata", (JsonNode)kogito);
        json.setAll((ObjectNode)JsonUtils.getObjectMapper().valueToTree((Object)((ProcessInstanceEventBody)event.getData()).getVariables()));
        return json;
    }

    private ObjectNode getProcessJson(ProcessInstanceDataEvent event) {
        ObjectNode json = JsonUtils.getObjectMapper().createObjectNode();
        json.put("id", ((ProcessInstanceEventBody)event.getData()).getId());
        json.put("processId", ((ProcessInstanceEventBody)event.getData()).getProcessId());
        json.put("processName", ((ProcessInstanceEventBody)event.getData()).getProcessName());
        if (!Strings.isNullOrEmpty((String)((ProcessInstanceEventBody)event.getData()).getRootInstanceId())) {
            json.put("rootProcessInstanceId", ((ProcessInstanceEventBody)event.getData()).getRootInstanceId());
        }
        if (!Strings.isNullOrEmpty((String)((ProcessInstanceEventBody)event.getData()).getParentInstanceId())) {
            json.put("parentProcessInstanceId", ((ProcessInstanceEventBody)event.getData()).getParentInstanceId());
        }
        if (!Strings.isNullOrEmpty((String)((ProcessInstanceEventBody)event.getData()).getRootProcessId())) {
            json.put("rootProcessId", ((ProcessInstanceEventBody)event.getData()).getRootProcessId());
        }
        json.put("state", ((ProcessInstanceEventBody)event.getData()).getState());
        if (event.getSource() != null) {
            json.put("endpoint", event.getSource().toString());
        }
        if (((ProcessInstanceEventBody)event.getData()).getStartDate() != null) {
            json.put("start", ((ProcessInstanceEventBody)event.getData()).getStartDate().toInstant().toEpochMilli());
        }
        if (((ProcessInstanceEventBody)event.getData()).getEndDate() != null) {
            json.put("end", ((ProcessInstanceEventBody)event.getData()).getEndDate().toInstant().toEpochMilli());
        }
        if (event.getTime() != null) {
            json.put("lastUpdate", event.getTime().toInstant().toEpochMilli());
        }
        if (!Strings.isNullOrEmpty((String)((ProcessInstanceEventBody)event.getData()).getBusinessKey())) {
            json.put("businessKey", ((ProcessInstanceEventBody)event.getData()).getBusinessKey());
        }
        return json;
    }
}

