/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import io.quarkus.arc.properties.IfBuildProperty;
import io.smallrye.reactive.messaging.annotations.Blocking;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.index.event.KogitoJobCloudEvent;
import org.kie.kogito.index.event.ProcessInstanceEventMapper;
import org.kie.kogito.index.event.UserTaskInstanceEventMapper;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.service.IndexingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@IfBuildProperty(name="kogito.data-index.blocking", stringValue="true")
public class BlockingMessagingEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingMessagingEventConsumer.class);
    @Inject
    Event<DataEvent> eventPublisher;
    @Inject
    IndexingService indexingService;

    @Incoming(value="kogito-processinstances-events")
    @Blocking
    @Transactional
    public void onProcessInstanceEvent(ProcessInstanceDataEvent event) {
        LOGGER.debug("Process instance consumer received ProcessInstanceDataEvent: \n{}", (Object)event);
        this.indexingService.indexProcessInstance(new ProcessInstanceEventMapper().apply(event));
        this.eventPublisher.fire((Object)event);
    }

    @Incoming(value="kogito-usertaskinstances-events")
    @Blocking
    @Transactional
    public void onUserTaskInstanceEvent(UserTaskInstanceDataEvent event) {
        LOGGER.debug("Task instance received UserTaskInstanceDataEvent \n{}", (Object)event);
        this.indexingService.indexUserTaskInstance(new UserTaskInstanceEventMapper().apply(event));
        this.eventPublisher.fire((Object)event);
    }

    @Incoming(value="kogito-jobs-events")
    @Blocking
    @Transactional
    public void onJobEvent(KogitoJobCloudEvent event) {
        LOGGER.debug("Job received KogitoJobCloudEvent \n{}", (Object)event);
        this.indexingService.indexJob((Job)event.getData());
    }
}

