/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.index.graphql.query.AbstractInputObjectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLOrderByTypeMapper
extends AbstractInputObjectTypeMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLOrderByTypeMapper.class);
    private static final String ORDER_BY = "OrderBy";

    public GraphQLOrderByTypeMapper(GraphQLSchema schema, Map<String, GraphQLType> additionalTypes) {
        super(schema, additionalTypes);
    }

    @Override
    public String getTypeName(GraphQLObjectType type) {
        return type.getName() + ORDER_BY;
    }

    @Override
    protected Function<GraphQLObjectType, List<GraphQLInputObjectField>> build() {
        return domain -> domain.getFieldDefinitions().stream().filter(field -> !(field.getType() instanceof GraphQLList)).filter(field -> !"processInstances".equals(field.getName())).filter(field -> !"userTasks".equals(field.getName())).filter(field -> !"id".equals(field.getName())).map(field -> {
            LOGGER.debug("GraphQL mapping field: {}", (Object)field.getName());
            String typeName = this.getTypeName((GraphQLFieldDefinition)field);
            if (typeName != null) {
                return GraphQLInputObjectField.newInputObjectField().name(field.getName()).type((GraphQLInputType)new GraphQLTypeReference(typeName)).build();
            }
            LOGGER.warn("Can not map order by type for field name: {}, type: {}", (Object)field.getName(), (Object)((GraphQLNamedType)field.getType()).getName());
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getTypeName(GraphQLFieldDefinition field) {
        String name;
        switch (name = ((GraphQLNamedType)field.getType()).getName()) {
            case "Int": 
            case "Long": 
            case "String": 
            case "Boolean": 
            case "DateTime": {
                return ORDER_BY;
            }
        }
        String typeName = name + ORDER_BY;
        if (this.getSchema().getType(typeName) == null && !this.getAdditionalTypes().containsKey(typeName)) {
            GraphQLObjectType objectType = (GraphQLObjectType)this.getAdditionalTypes().get(name);
            if (objectType == null) {
                return null;
            }
            GraphQLInputObjectType type = new GraphQLOrderByTypeMapper(this.getSchema(), this.getAdditionalTypes()).apply(objectType);
            if (type != null) {
                this.getAdditionalTypes().put(typeName, (GraphQLType)type);
            } else {
                return null;
            }
        }
        return typeName;
    }
}

