/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.kogito.index.graphql.GraphQLObjectTypeMapper;
import org.kie.kogito.index.graphql.GraphQLSchemaManager;
import org.kie.kogito.index.graphql.query.GraphQLInputObjectTypeMapper;
import org.kie.kogito.index.graphql.query.GraphQLOrderByTypeMapper;
import org.kie.kogito.index.graphql.query.GraphQLQueryParserRegistry;
import org.kie.kogito.persistence.api.proto.DomainDescriptor;
import org.kie.kogito.persistence.api.proto.DomainModelRegisteredEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GraphQLProtoSchemaMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLProtoSchemaMapper.class);
    @Inject
    GraphQLSchemaManager schemaManager;

    public void onDomainModelRegisteredEvent(@Observes DomainModelRegisteredEvent event) {
        LOGGER.debug("Received new domain event: {}", (Object)event);
        GraphQLSchema schema = this.schemaManager.getGraphQLSchema();
        this.schemaManager.transform(builder -> {
            GraphQLInputObjectType orderByType;
            builder.clearAdditionalTypes();
            Map<String, DomainDescriptor> map = event.getAdditionalTypes().stream().collect(Collectors.toMap(desc -> GraphQLObjectTypeMapper.getTypeName(desc.getTypeName()), desc -> desc));
            ConcurrentHashMap<String, GraphQLType> additionalTypes = new ConcurrentHashMap<String, GraphQLType>();
            GraphQLObjectType rootType = new GraphQLObjectTypeMapper(schema, additionalTypes, map).apply(event.getDomainDescriptor());
            additionalTypes.put(rootType.getName(), (GraphQLType)rootType);
            GraphQLInputObjectType whereArgumentType = new GraphQLInputObjectTypeMapper(schema, additionalTypes).apply(rootType);
            if (!whereArgumentType.getFields().isEmpty()) {
                additionalTypes.put(whereArgumentType.getName(), (GraphQLType)whereArgumentType);
            }
            if ((orderByType = new GraphQLOrderByTypeMapper(schema, additionalTypes).apply(rootType)) != null) {
                additionalTypes.put(orderByType.getName(), (GraphQLType)orderByType);
            }
            LOGGER.debug("New GraphQL types: {}", additionalTypes.keySet());
            Set newTypes = additionalTypes.entrySet().stream().map(entry -> (GraphQLType)entry.getValue()).collect(Collectors.toSet());
            newTypes.addAll(schema.getAdditionalTypes().stream().filter(type -> !additionalTypes.containsKey(((GraphQLNamedType)type).getName())).collect(Collectors.toSet()));
            builder.additionalTypes(newTypes);
            GraphQLObjectType query = schema.getQueryType();
            query = query.transform(qBuilder -> {
                if (qBuilder.hasField(rootType.getName())) {
                    qBuilder.clearFields();
                    qBuilder.fields(schema.getQueryType().getFieldDefinitions().stream().filter(field -> !rootType.getName().equals(field.getName())).collect(Collectors.toList()));
                }
                ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
                if (!whereArgumentType.getFields().isEmpty()) {
                    GraphQLQueryParserRegistry.get().registerParser(whereArgumentType);
                    arguments.add(GraphQLArgument.newArgument().name("where").type((GraphQLInputType)whereArgumentType).build());
                }
                if (orderByType != null) {
                    arguments.add(GraphQLArgument.newArgument().name("orderBy").type((GraphQLInputType)orderByType).build());
                }
                arguments.add(GraphQLArgument.newArgument().name("pagination").type((GraphQLInputType)new GraphQLTypeReference("Pagination")).build());
                qBuilder.field(GraphQLFieldDefinition.newFieldDefinition().name(rootType.getName()).type((GraphQLOutputType)GraphQLList.list((GraphQLType)rootType)).arguments(arguments));
            });
            builder.query(query);
            GraphQLObjectType subscription = schema.getSubscriptionType();
            subscription = subscription.transform(sBuilder -> {
                sBuilder.field(GraphQLFieldDefinition.newFieldDefinition().name(rootType.getName() + "Added").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)rootType)).build());
                sBuilder.field(GraphQLFieldDefinition.newFieldDefinition().name(rootType.getName() + "Updated").type((GraphQLOutputType)GraphQLNonNull.nonNull((GraphQLType)rootType)).build());
            });
            builder.subscription(subscription);
            GraphQLCodeRegistry registry = schema.getCodeRegistry().transform(codeBuilder -> {
                codeBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Query", (String)rootType.getName()), this.schemaManager.getDomainModelDataFetcher(event.getProcessId()));
                codeBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Subscription", (String)(rootType.getName() + "Added")), this.schemaManager.getDomainModelAddedDataFetcher(event.getProcessId()));
                codeBuilder.dataFetcher(FieldCoordinates.coordinates((String)"Subscription", (String)(rootType.getName() + "Updated")), this.schemaManager.getDomainModelUpdatedDataFetcher(event.getProcessId()));
            });
            builder.codeRegistry(registry);
        });
    }
}

