/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.event;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.net.UrlEscapers;
import java.net.URI;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.event.process.AttachmentEventBody;
import org.kie.kogito.event.process.CommentEventBody;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceEventBody;
import org.kie.kogito.index.DateTimeUtils;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.Attachment;
import org.kie.kogito.index.model.Comment;
import org.kie.kogito.index.model.UserTaskInstance;

public class UserTaskInstanceEventMapper
implements Function<UserTaskInstanceDataEvent, UserTaskInstance> {
    @Override
    public UserTaskInstance apply(UserTaskInstanceDataEvent event) {
        if (event == null || event.getData() == null) {
            return null;
        }
        UserTaskInstance task = new UserTaskInstance();
        task.setId(((UserTaskInstanceEventBody)event.getData()).getId());
        task.setProcessInstanceId(((UserTaskInstanceEventBody)event.getData()).getProcessInstanceId());
        task.setProcessId(((UserTaskInstanceEventBody)event.getData()).getProcessId());
        task.setRootProcessId(((UserTaskInstanceEventBody)event.getData()).getRootProcessId());
        task.setRootProcessInstanceId(((UserTaskInstanceEventBody)event.getData()).getRootProcessInstanceId());
        task.setName(((UserTaskInstanceEventBody)event.getData()).getTaskName());
        task.setDescription(((UserTaskInstanceEventBody)event.getData()).getTaskDescription());
        task.setState(((UserTaskInstanceEventBody)event.getData()).getState());
        task.setPriority(((UserTaskInstanceEventBody)event.getData()).getTaskPriority());
        task.setStarted(DateTimeUtils.toZonedDateTime(((UserTaskInstanceEventBody)event.getData()).getStartDate()));
        task.setCompleted(DateTimeUtils.toZonedDateTime(((UserTaskInstanceEventBody)event.getData()).getCompleteDate()));
        task.setActualOwner(((UserTaskInstanceEventBody)event.getData()).getActualOwner());
        task.setAdminUsers(((UserTaskInstanceEventBody)event.getData()).getAdminUsers());
        task.setAdminGroups(((UserTaskInstanceEventBody)event.getData()).getAdminGroups());
        task.setExcludedUsers(((UserTaskInstanceEventBody)event.getData()).getExcludedUsers());
        task.setPotentialUsers(((UserTaskInstanceEventBody)event.getData()).getPotentialUsers());
        task.setPotentialGroups(((UserTaskInstanceEventBody)event.getData()).getPotentialGroups());
        task.setComments(((UserTaskInstanceEventBody)event.getData()).getComments().stream().map(this.comment()).collect(Collectors.toList()));
        task.setAttachments(((UserTaskInstanceEventBody)event.getData()).getAttachments().stream().map(this.attachment()).collect(Collectors.toList()));
        task.setInputs((ObjectNode)JsonUtils.getObjectMapper().valueToTree((Object)((UserTaskInstanceEventBody)event.getData()).getInputs()));
        task.setOutputs((ObjectNode)JsonUtils.getObjectMapper().valueToTree((Object)((UserTaskInstanceEventBody)event.getData()).getOutputs()));
        task.setEndpoint(this.getEndpoint(event.getSource(), ((UserTaskInstanceEventBody)event.getData()).getProcessInstanceId(), ((UserTaskInstanceEventBody)event.getData()).getTaskName(), ((UserTaskInstanceEventBody)event.getData()).getId()));
        task.setLastUpdate(DateTimeUtils.toZonedDateTime(event.getTime()));
        task.setReferenceName(((UserTaskInstanceEventBody)event.getData()).getReferenceName());
        return task;
    }

    private Function<CommentEventBody, Comment> comment() {
        return c -> Comment.builder().id(c.getId()).content(c.getContent()).updatedBy(c.getUpdatedBy()).updatedAt(DateTimeUtils.toZonedDateTime(c.getUpdatedAt())).build();
    }

    private Function<AttachmentEventBody, Attachment> attachment() {
        return a -> Attachment.builder().id(a.getId()).content(a.getContent() == null ? null : a.getContent().toString()).name(a.getName()).updatedBy(a.getUpdatedBy()).updatedAt(DateTimeUtils.toZonedDateTime(a.getUpdatedAt())).build();
    }

    protected String getEndpoint(URI source, String pId, String taskName, String taskId) {
        String name = UrlEscapers.urlPathSegmentEscaper().escape(taskName);
        return source.toString() + String.format("/%s/%s/%s", pId, name, taskId);
    }
}

