/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.kie.kogito.index.graphql.query.AbstractInputObjectTypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLInputObjectTypeMapper
extends AbstractInputObjectTypeMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLInputObjectTypeMapper.class);
    private static final String ARGUMENT = "Argument";
    private boolean mapOperators;

    public GraphQLInputObjectTypeMapper(GraphQLSchema schema, Map<String, GraphQLType> additionalTypes, boolean mapOperators) {
        super(schema, additionalTypes);
        this.mapOperators = mapOperators;
    }

    public GraphQLInputObjectTypeMapper(GraphQLSchema schema, Map<String, GraphQLType> additionalTypes) {
        this(schema, additionalTypes, true);
    }

    @Override
    protected String getTypeName(GraphQLObjectType type) {
        return type.getName() + ARGUMENT;
    }

    @Override
    protected Function<GraphQLObjectType, List<GraphQLInputObjectField>> build() {
        return domain -> {
            ArrayList<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();
            if (this.mapOperators) {
                fields.add(GraphQLInputObjectField.newInputObjectField().name("and").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)new GraphQLTypeReference(this.getTypeName((GraphQLObjectType)domain))))).build());
                fields.add(GraphQLInputObjectField.newInputObjectField().name("or").type((GraphQLInputType)GraphQLList.list((GraphQLType)GraphQLNonNull.nonNull((GraphQLType)new GraphQLTypeReference(this.getTypeName((GraphQLObjectType)domain))))).build());
                fields.add(GraphQLInputObjectField.newInputObjectField().name("not").type((GraphQLInputType)new GraphQLTypeReference(this.getTypeName((GraphQLObjectType)domain))).build());
            }
            domain.getFieldDefinitions().forEach(field -> {
                LOGGER.debug("GraphQL mapping field: {}", (Object)field.getName());
                if ("metadata".equals(field.getName())) {
                    fields.add(GraphQLInputObjectField.newInputObjectField().name("metadata").type((GraphQLInputType)new GraphQLTypeReference("KogitoMetadataArgument")).build());
                } else if ("id".equals(field.getName())) {
                    fields.add(GraphQLInputObjectField.newInputObjectField().name("id").type((GraphQLInputType)new GraphQLTypeReference("IdArgument")).build());
                } else {
                    GraphQLInputType inputTypeByField = this.getInputTypeByField((GraphQLFieldDefinition)field);
                    if (inputTypeByField == null) {
                        LOGGER.warn("Can not map input type for field name: {}, type: {}", (Object)field.getName(), (Object)((GraphQLNamedType)field.getType()).getName());
                    } else {
                        fields.add(GraphQLInputObjectField.newInputObjectField().name(field.getName()).type(inputTypeByField).build());
                    }
                }
            });
            return fields;
        };
    }

    private GraphQLInputType getInputTypeByField(GraphQLFieldDefinition field) {
        String name;
        switch (name = this.resolveBaseTypeName(field.getType())) {
            case "Int": 
            case "Long": {
                return this.getInputObjectType("NumericArgument");
            }
            case "String": {
                return this.getInputObjectType("StringArgument");
            }
            case "Boolean": {
                return this.getInputObjectType("BooleanArgument");
            }
            case "DateTime": {
                return this.getInputObjectType("DateArgument");
            }
        }
        String typeName = name + ARGUMENT;
        GraphQLType schemaType = this.getExistingType(typeName);
        if (schemaType == null) {
            GraphQLObjectType domain = (GraphQLObjectType)this.getAdditionalTypes().get(name);
            if (domain == null) {
                return null;
            }
            GraphQLInputObjectType type = new GraphQLInputObjectTypeMapper(this.getSchema(), this.getAdditionalTypes(), false).apply(domain);
            this.getAdditionalTypes().put(typeName, (GraphQLType)type);
            return type;
        }
        return (GraphQLInputType)schemaType;
    }

    private GraphQLType getExistingType(String typeName) {
        GraphQLType schemaType = this.getSchema().getType(typeName);
        return schemaType == null ? this.getAdditionalTypes().get(typeName) : schemaType;
    }
}

