/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service.messaging;

import io.quarkus.arc.properties.UnlessBuildProperty;
import io.smallrye.mutiny.Uni;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.index.event.KogitoJobCloudEvent;
import org.kie.kogito.index.event.ProcessInstanceEventMapper;
import org.kie.kogito.index.event.UserTaskInstanceEventMapper;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.service.IndexingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@UnlessBuildProperty(name="kogito.data-index.blocking", stringValue="true", enableIfMissing=true)
public class ReactiveMessagingEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMessagingEventConsumer.class);
    public static final String KOGITO_PROCESSINSTANCES_EVENTS = "kogito-processinstances-events";
    public static final String KOGITO_USERTASKINSTANCES_EVENTS = "kogito-usertaskinstances-events";
    public static final String KOGITO_JOBS_EVENTS = "kogito-jobs-events";
    @Inject
    IndexingService indexingService;
    @Inject
    Event<DataEvent> eventPublisher;

    @Incoming(value="kogito-processinstances-events")
    public Uni<Void> onProcessInstanceEvent(ProcessInstanceDataEvent event) {
        LOGGER.debug("Process instance consumer received ProcessInstanceDataEvent: \n{}", (Object)event);
        return Uni.createFrom().item((Object)event).invoke(e -> this.indexingService.indexProcessInstance(new ProcessInstanceEventMapper().apply(e))).invoke(e -> this.eventPublisher.fire(e)).onFailure().invoke(t -> LOGGER.error("Error processing process instance ProcessInstanceDataEvent: {}", (Object)t.getMessage(), t)).onItem().ignore().andContinueWithNull();
    }

    @Incoming(value="kogito-usertaskinstances-events")
    public Uni<Void> onUserTaskInstanceEvent(UserTaskInstanceDataEvent event) {
        LOGGER.debug("Task instance received UserTaskInstanceDataEvent \n{}", (Object)event);
        return Uni.createFrom().item((Object)event).invoke(e -> this.indexingService.indexUserTaskInstance(new UserTaskInstanceEventMapper().apply(e))).invoke(e -> this.eventPublisher.fire(e)).onFailure().invoke(t -> LOGGER.error("Error processing task instance UserTaskInstanceDataEvent: {}", (Object)t.getMessage(), t)).onItem().ignore().andContinueWithNull();
    }

    @Incoming(value="kogito-jobs-events")
    public Uni<Void> onJobEvent(KogitoJobCloudEvent event) {
        LOGGER.debug("Job received KogitoJobCloudEvent \n{}", (Object)event);
        return Uni.createFrom().item((Object)event).onItem().invoke(e -> this.indexingService.indexJob((Job)e.getData())).onFailure().invoke(t -> LOGGER.error("Error processing job KogitoJobCloudEvent: {}", (Object)t.getMessage(), t)).onItem().ignore().andContinueWithNull();
    }
}

