/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import graphql.scalars.ExtendedScalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.index.graphql.AbstractGraphQLSchemaManager;
import org.kie.kogito.index.graphql.query.GraphQLQueryParserRegistry;
import org.kie.kogito.index.json.DataIndexParsingException;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.service.DataIndexServiceException;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class GraphQLSchemaManagerImpl
extends AbstractGraphQLSchemaManager {
    private static final String PROCESS_INSTANCE_ADDED = "ProcessInstanceAdded";
    private static final String PROCESS_INSTANCE_UPDATED = "ProcessInstanceUpdated";
    private static final String USER_TASK_INSTANCE_ADDED = "UserTaskInstanceAdded";
    private static final String USER_TASK_INSTANCE_UPDATED = "UserTaskInstanceUpdated";
    private static final String JOB_UPDATED = "JobUpdated";
    private static final String JOB_ADDED = "JobAdded";
    private static final String USER = "user";
    private static final String GROUPS = "groups";
    private static final String TASK_ID = "taskId";
    private static final String COMMENT_ID = "commentId";
    private static final String ATTACHMENT_ID = "attachmentId";

    @PostConstruct
    public void setup() {
        super.setup();
        GraphQLQueryParserRegistry.get().registerParsers(new GraphQLInputObjectType[]{(GraphQLInputObjectType)this.getGraphQLSchema().getType("KogitoMetadataArgument"), (GraphQLInputObjectType)this.getGraphQLSchema().getType("JobArgument")});
    }

    public GraphQLSchema createSchema() {
        TypeDefinitionRegistry typeDefinitionRegistry = new TypeDefinitionRegistry();
        typeDefinitionRegistry.merge(this.loadSchemaDefinitionFile("basic.schema.graphqls"));
        typeDefinitionRegistry.merge(this.loadSchemaDefinitionFile("domain.schema.graphqls"));
        RuntimeWiring runtimeWiring = RuntimeWiring.newRuntimeWiring().type("Query", builder -> {
            builder.dataFetcher("ProcessInstances", arg_0 -> ((GraphQLSchemaManagerImpl)this).getProcessInstancesValues(arg_0));
            builder.dataFetcher("UserTaskInstances", arg_0 -> ((GraphQLSchemaManagerImpl)this).getUserTaskInstancesValues(arg_0));
            builder.dataFetcher("Jobs", this::getJobsValues);
            return builder;
        }).type("Mutation", builder -> {
            builder.dataFetcher("ProcessInstanceAbort", this::abortProcessInstance);
            builder.dataFetcher("ProcessInstanceRetry", this::retryProcessInstance);
            builder.dataFetcher("ProcessInstanceSkip", this::skipProcessInstance);
            builder.dataFetcher("ProcessInstanceUpdateVariables", this::updateProcessInstanceVariables);
            builder.dataFetcher("NodeInstanceTrigger", this::triggerNodeInstance);
            builder.dataFetcher("NodeInstanceRetrigger", this::retriggerNodeInstance);
            builder.dataFetcher("NodeInstanceCancel", this::cancelNodeInstance);
            builder.dataFetcher("JobCancel", this::cancelJob);
            builder.dataFetcher("JobReschedule", this::rescheduleJob);
            builder.dataFetcher("UserTaskInstanceUpdate", this::updateUserTaskInstance);
            builder.dataFetcher("UserTaskInstanceCommentCreate", this::createTaskInstanceComment);
            builder.dataFetcher("UserTaskInstanceAttachmentCreate", this::createTaskInstanceAttachment);
            builder.dataFetcher("UserTaskInstanceCommentUpdate", this::updateUserTaskComment);
            builder.dataFetcher("UserTaskInstanceCommentDelete", this::deleteUserTaskComment);
            builder.dataFetcher("UserTaskInstanceAttachmentUpdate", this::updateUserTaskAttachment);
            builder.dataFetcher("UserTaskInstanceAttachmentDelete", this::deleteUserTaskAttachment);
            return builder;
        }).type("ProcessInstance", builder -> {
            builder.dataFetcher("parentProcessInstance", arg_0 -> ((GraphQLSchemaManagerImpl)this).getParentProcessInstanceValue(arg_0));
            builder.dataFetcher("childProcessInstances", arg_0 -> ((GraphQLSchemaManagerImpl)this).getChildProcessInstancesValues(arg_0));
            builder.dataFetcher("serviceUrl", arg_0 -> ((GraphQLSchemaManagerImpl)this).getProcessInstanceServiceUrl(arg_0));
            builder.dataFetcher("diagram", arg_0 -> ((GraphQLSchemaManagerImpl)this).getProcessInstanceDiagram(arg_0));
            builder.dataFetcher("source", arg_0 -> ((GraphQLSchemaManagerImpl)this).getProcessInstanceSourceFileContent(arg_0));
            builder.dataFetcher("nodeDefinitions", arg_0 -> ((GraphQLSchemaManagerImpl)this).getProcessNodes(arg_0));
            return builder;
        }).type("UserTaskInstance", builder -> {
            builder.dataFetcher("schema", this::getUserTaskInstanceSchema);
            return builder;
        }).type("ProcessInstanceMeta", builder -> {
            builder.dataFetcher("serviceUrl", this::getProcessInstanceJsonServiceUrl);
            return builder;
        }).type("ProcessInstanceState", builder -> {
            builder.enumValues(name -> ProcessInstanceState.valueOf((String)name).ordinal());
            return builder;
        }).type("Subscription", builder -> {
            builder.dataFetcher(PROCESS_INSTANCE_ADDED, this.getProcessInstanceAddedDataFetcher());
            builder.dataFetcher(PROCESS_INSTANCE_UPDATED, this.getProcessInstanceUpdatedDataFetcher());
            builder.dataFetcher(USER_TASK_INSTANCE_ADDED, this.getUserTaskInstanceAddedDataFetcher());
            builder.dataFetcher(USER_TASK_INSTANCE_UPDATED, this.getUserTaskInstanceUpdatedDataFetcher());
            builder.dataFetcher(JOB_ADDED, this.getJobAddedDataFetcher());
            builder.dataFetcher(JOB_UPDATED, this.getJobUpdatedDataFetcher());
            return builder;
        }).scalar(this.getDateTimeScalarType()).scalar(ExtendedScalars.GraphQLBigDecimal).scalar(ExtendedScalars.GraphQLLong).build();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        return schemaGenerator.makeExecutableSchema(typeDefinitionRegistry, runtimeWiring);
    }

    public CompletableFuture<String> abortProcessInstance(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)this.getCacheService().getProcessInstancesCache().get((Object)((String)env.getArgument("id")));
        return this.getDataIndexApiExecutor().abortProcessInstance(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance);
    }

    public CompletableFuture<String> retryProcessInstance(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)this.getCacheService().getProcessInstancesCache().get((Object)((String)env.getArgument("id")));
        return this.getDataIndexApiExecutor().retryProcessInstance(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance);
    }

    public CompletableFuture<String> skipProcessInstance(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)this.getCacheService().getProcessInstancesCache().get((Object)((String)env.getArgument("id")));
        return this.getDataIndexApiExecutor().skipProcessInstance(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance);
    }

    public CompletableFuture<String> updateProcessInstanceVariables(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)this.getCacheService().getProcessInstancesCache().get((Object)((String)env.getArgument("id")));
        return this.getDataIndexApiExecutor().updateProcessInstanceVariables(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance, (String)env.getArgument("variables"));
    }

    public CompletableFuture<String> triggerNodeInstance(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)this.getCacheService().getProcessInstancesCache().get((Object)((String)env.getArgument("id")));
        return this.getDataIndexApiExecutor().triggerNodeInstance(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance, (String)env.getArgument("nodeId"));
    }

    public CompletableFuture<String> retriggerNodeInstance(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)this.getCacheService().getProcessInstancesCache().get((Object)((String)env.getArgument("id")));
        return this.getDataIndexApiExecutor().retriggerNodeInstance(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance, (String)env.getArgument("nodeInstanceId"));
    }

    public CompletableFuture<String> cancelNodeInstance(DataFetchingEnvironment env) {
        ProcessInstance processInstance = (ProcessInstance)this.getCacheService().getProcessInstancesCache().get((Object)((String)env.getArgument("id")));
        return this.getDataIndexApiExecutor().cancelNodeInstance(this.getServiceUrl(processInstance.getEndpoint(), processInstance.getProcessId()), processInstance, (String)env.getArgument("nodeInstanceId"));
    }

    public CompletableFuture<String> cancelJob(DataFetchingEnvironment env) {
        Job job = (Job)this.getCacheService().getJobsCache().get((Object)((String)env.getArgument("id")));
        return this.getDataIndexApiExecutor().cancelJob(job.getEndpoint(), job);
    }

    public CompletableFuture<String> rescheduleJob(DataFetchingEnvironment env) {
        Job job = (Job)this.getCacheService().getJobsCache().get((Object)((String)env.getArgument("id")));
        return this.getDataIndexApiExecutor().rescheduleJob(job.getEndpoint(), job, (String)env.getArgument("data"));
    }

    protected String getProcessInstanceJsonServiceUrl(DataFetchingEnvironment env) {
        Object source = env.getSource();
        if (source instanceof JsonNode) {
            String endpoint = ((JsonNode)source).get("endpoint").asText();
            String processId = ((JsonNode)source).get("processId").asText();
            return this.getServiceUrl(endpoint, processId);
        }
        return null;
    }

    private CompletableFuture<String> getUserTaskInstanceSchema(DataFetchingEnvironment env) {
        UserTaskInstance userTaskInstance = (UserTaskInstance)env.getSource();
        return this.getDataIndexApiExecutor().getUserTaskSchema(this.getServiceUrl(userTaskInstance.getEndpoint(), userTaskInstance.getProcessId()), userTaskInstance, (String)env.getArgument(USER), (List)env.getArgument(GROUPS));
    }

    private CompletableFuture<String> updateUserTaskInstance(DataFetchingEnvironment env) {
        UserTaskInstance userTaskInstance = (UserTaskInstance)this.getCacheService().getUserTaskInstancesCache().get((Object)((String)env.getArgument(TASK_ID)));
        return this.getDataIndexApiExecutor().updateUserTaskInstance(this.getServiceUrl(userTaskInstance.getEndpoint(), userTaskInstance.getProcessId()), userTaskInstance, (String)env.getArgument(USER), (List)env.getArgument(GROUPS), env.getArguments());
    }

    private CompletableFuture<String> createTaskInstanceComment(DataFetchingEnvironment env) {
        UserTaskInstance userTaskInstance = (UserTaskInstance)this.getCacheService().getUserTaskInstancesCache().get((Object)((String)env.getArgument(TASK_ID)));
        return this.getDataIndexApiExecutor().createUserTaskInstanceComment(this.getServiceUrl(userTaskInstance.getEndpoint(), userTaskInstance.getProcessId()), userTaskInstance, (String)env.getArgument(USER), (List)env.getArgument(GROUPS), (String)env.getArgument("comment"));
    }

    private CompletableFuture<String> createTaskInstanceAttachment(DataFetchingEnvironment env) {
        UserTaskInstance userTaskInstance = (UserTaskInstance)this.getCacheService().getUserTaskInstancesCache().get((Object)((String)env.getArgument(TASK_ID)));
        return this.getDataIndexApiExecutor().createUserTaskInstanceAttachment(this.getServiceUrl(userTaskInstance.getEndpoint(), userTaskInstance.getProcessId()), userTaskInstance, (String)env.getArgument(USER), (List)env.getArgument(GROUPS), (String)env.getArgument("name"), (String)env.getArgument("uri"));
    }

    private CompletableFuture<String> updateUserTaskComment(DataFetchingEnvironment env) {
        Query query = this.getCacheService().getUserTaskInstancesCache().query();
        query.filter(Collections.singletonList(QueryFilterFactory.equalTo((String)"comments.id", (Object)env.getArgument(COMMENT_ID))));
        UserTaskInstance userTaskInstance = (UserTaskInstance)query.execute().get(0);
        return this.getDataIndexApiExecutor().updateUserTaskInstanceComment(this.getServiceUrl(userTaskInstance.getEndpoint(), userTaskInstance.getProcessId()), userTaskInstance, (String)env.getArgument(USER), (List)env.getArgument(GROUPS), (String)env.getArgument(COMMENT_ID), (String)env.getArgument("comment"));
    }

    private CompletableFuture<String> deleteUserTaskComment(DataFetchingEnvironment env) {
        Query query = this.getCacheService().getUserTaskInstancesCache().query();
        query.filter(Collections.singletonList(QueryFilterFactory.equalTo((String)"comments.id", (Object)env.getArgument(COMMENT_ID))));
        UserTaskInstance userTaskInstance = (UserTaskInstance)query.execute().get(0);
        return this.getDataIndexApiExecutor().deleteUserTaskInstanceComment(this.getServiceUrl(userTaskInstance.getEndpoint(), userTaskInstance.getProcessId()), userTaskInstance, (String)env.getArgument(USER), (List)env.getArgument(GROUPS), (String)env.getArgument(COMMENT_ID));
    }

    private CompletableFuture<String> updateUserTaskAttachment(DataFetchingEnvironment env) {
        Query query = this.getCacheService().getUserTaskInstancesCache().query();
        query.filter(Collections.singletonList(QueryFilterFactory.equalTo((String)"attachments.id", (Object)env.getArgument(ATTACHMENT_ID))));
        UserTaskInstance userTaskInstance = (UserTaskInstance)query.execute().get(0);
        return this.getDataIndexApiExecutor().updateUserTaskInstanceAttachment(this.getServiceUrl(userTaskInstance.getEndpoint(), userTaskInstance.getProcessId()), userTaskInstance, (String)env.getArgument(USER), (List)env.getArgument(GROUPS), (String)env.getArgument(ATTACHMENT_ID), (String)env.getArgument("name"), (String)env.getArgument("uri"));
    }

    private CompletableFuture<String> deleteUserTaskAttachment(DataFetchingEnvironment env) {
        Query query = this.getCacheService().getUserTaskInstancesCache().query();
        query.filter(Collections.singletonList(QueryFilterFactory.equalTo((String)"attachments.id", (Object)env.getArgument(ATTACHMENT_ID))));
        UserTaskInstance userTaskInstance = (UserTaskInstance)query.execute().get(0);
        return this.getDataIndexApiExecutor().deleteUserTaskInstanceAttachment(this.getServiceUrl(userTaskInstance.getEndpoint(), userTaskInstance.getProcessId()), userTaskInstance, (String)env.getArgument(USER), (List)env.getArgument(GROUPS), (String)env.getArgument(ATTACHMENT_ID));
    }

    protected Collection<Job> getJobsValues(DataFetchingEnvironment env) {
        return this.executeAdvancedQueryForCache(this.getCacheService().getJobsCache(), env);
    }

    private DataFetcher<Publisher<ObjectNode>> getProcessInstanceAddedDataFetcher() {
        return this.objectCreatedPublisher(() -> this.getCacheService().getProcessInstancesCache());
    }

    private DataFetcher<Publisher<ObjectNode>> getProcessInstanceUpdatedDataFetcher() {
        return this.objectUpdatedPublisher(() -> this.getCacheService().getProcessInstancesCache());
    }

    private DataFetcher<Publisher<ObjectNode>> getUserTaskInstanceAddedDataFetcher() {
        return this.objectCreatedPublisher(() -> this.getCacheService().getUserTaskInstancesCache());
    }

    private DataFetcher<Publisher<ObjectNode>> getUserTaskInstanceUpdatedDataFetcher() {
        return this.objectUpdatedPublisher(() -> this.getCacheService().getUserTaskInstancesCache());
    }

    private DataFetcher<Publisher<ObjectNode>> getJobUpdatedDataFetcher() {
        return this.objectUpdatedPublisher(() -> this.getCacheService().getJobsCache());
    }

    private DataFetcher<Publisher<ObjectNode>> getJobAddedDataFetcher() {
        return this.objectCreatedPublisher(() -> this.getCacheService().getJobsCache());
    }

    private DataFetcher<Publisher<ObjectNode>> objectCreatedPublisher(Supplier<Storage> cache) {
        return env -> ((Storage)cache.get()).objectCreatedListener();
    }

    private DataFetcher<Publisher<ObjectNode>> objectUpdatedPublisher(Supplier<Storage> cache) {
        return env -> ((Storage)cache.get()).objectUpdatedListener();
    }

    private Supplier<DataIndexServiceException> cacheNotFoundException(String processId) {
        return () -> new DataIndexServiceException(String.format("Cache for process %s not found", processId));
    }

    protected DataFetcher<Publisher<ObjectNode>> getDomainModelUpdatedDataFetcher(String processId) {
        return env -> Optional.ofNullable(this.getCacheService().getDomainModelCache(processId)).orElseThrow(this.cacheNotFoundException(processId)).objectUpdatedListener();
    }

    protected DataFetcher<Publisher<ObjectNode>> getDomainModelAddedDataFetcher(String processId) {
        return env -> Optional.ofNullable(this.getCacheService().getDomainModelCache(processId)).orElseThrow(this.cacheNotFoundException(processId)).objectCreatedListener();
    }

    protected DataFetcher<Collection<ObjectNode>> getDomainModelDataFetcher(String processId) {
        return env -> {
            List result = this.executeAdvancedQueryForCache(Optional.ofNullable(this.getCacheService().getDomainModelCache(processId)).orElseThrow(this.cacheNotFoundException(processId)), env);
            return result.stream().map(json -> {
                try {
                    return JsonUtils.getObjectMapper().readTree(json.toString());
                }
                catch (IOException e) {
                    throw new DataIndexParsingException("Failed to parse JSON: " + e.getMessage(), (Throwable)e);
                }
            }).collect(Collectors.toList());
        };
    }
}

