/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service.api;

import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.SecurityIdentity;
import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.index.api.KogitoRuntimeClient;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.Node;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.service.DataIndexServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KogitoRuntimeClientImpl
implements KogitoRuntimeClient {
    public static final String ABORT_PROCESS_INSTANCE_PATH = "/management/processes/%s/instances/%s";
    public static final String RETRY_PROCESS_INSTANCE_PATH = "/management/processes/%s/instances/%s/retrigger";
    public static final String SKIP_PROCESS_INSTANCE_PATH = "/management/processes/%s/instances/%s/skip";
    public static final String GET_PROCESS_INSTANCE_DIAGRAM_PATH = "/svg/processes/%s/instances/%s";
    public static final String GET_PROCESS_INSTANCE_SOURCE_PATH = "/management/processes/%s/source";
    public static final String GET_PROCESS_INSTANCE_NODE_DEFINITIONS_PATH = "/management/processes/%s/nodes";
    public static final String UPDATE_VARIABLES_PROCESS_INSTANCE_PATH = "/%s/%s";
    public static final String TRIGGER_NODE_INSTANCE_PATH = "/management/processes/%s/instances/%s/nodes/%s";
    public static final String RETRIGGER_NODE_INSTANCE_PATH = "/management/processes/%s/instances/%s/nodeInstances/%s";
    public static final String CANCEL_NODE_INSTANCE_PATH = "/management/processes/%s/instances/%s/nodeInstances/%s";
    public static final String CANCEL_JOB_PATH = "/%s";
    public static final String RESCHEDULE_JOB_PATH = "/%s";
    public static final String GET_TASK_SCHEMA_PATH = "/%s/%s/%s/%s/schema";
    public static final String UPDATE_USER_TASK_INSTANCE_PATH = "/management/processes/%s/instances/%s/tasks/%s";
    public static final String CREATE_USER_TASK_INSTANCE_COMMENT_PATH = "/%s/%s/%s/%s/comments";
    public static final String UPDATE_USER_TASK_INSTANCE_COMMENT_PATH = "/%s/%s/%s/%s/comments/%s";
    public static final String DELETE_USER_TASK_INSTANCE_COMMENT_PATH = "/%s/%s/%s/%s/comments/%s";
    public static final String CREATE_USER_TASK_INSTANCE_ATTACHMENT_PATH = "/%s/%s/%s/%s/attachments";
    public static final String UPDATE_USER_TASK_INSTANCE_ATTACHMENT_PATH = "/%s/%s/%s/%s/attachments/%s";
    public static final String DELETE_USER_TASK_INSTANCE_ATTACHMENT_PATH = "/%s/%s/%s/%s/attachments/%s";
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoRuntimeClientImpl.class);
    private Vertx vertx;
    private SecurityIdentity identity;
    protected Map<String, WebClient> serviceWebClientMap = new HashMap<String, WebClient>();
    @ConfigProperty(name="kogito.dataindex.gateway.url")
    protected Optional<String> gatewayTargetUrl;

    @Inject
    public KogitoRuntimeClientImpl(Vertx vertx, SecurityIdentity identity) {
        this.vertx = vertx;
        this.identity = identity;
    }

    protected WebClient getWebClient(String runtimeServiceUrl) {
        if (runtimeServiceUrl == null) {
            throw new DataIndexServiceException("Runtime service URL not defined, please review the kogito.service.url system property to point the public URL for this runtime.");
        }
        return this.serviceWebClientMap.computeIfAbsent(runtimeServiceUrl, url -> WebClient.create((Vertx)this.vertx, (WebClientOptions)this.getWebClientToURLOptions(runtimeServiceUrl)));
    }

    protected WebClientOptions getWebClientToURLOptions(String targetHttpURL) {
        try {
            URL dataIndexURL = new URL(targetHttpURL);
            return new WebClientOptions().setDefaultHost(this.gatewayTargetUrl.orElse(dataIndexURL.getHost())).setDefaultPort(dataIndexURL.getPort() != -1 ? dataIndexURL.getPort() : dataIndexURL.getDefaultPort()).setSsl(dataIndexURL.getProtocol().compareToIgnoreCase("https") == 0);
        }
        catch (MalformedURLException ex) {
            LOGGER.error("Invalid runtime service URL: " + targetHttpURL, (Throwable)ex);
            return null;
        }
    }

    public CompletableFuture<String> abortProcessInstance(String serviceURL, ProcessInstance processInstance) {
        String requestURI = String.format(ABORT_PROCESS_INSTANCE_PATH, processInstance.getProcessId(), processInstance.getId());
        return this.sendDeleteClientRequest(this.getWebClient(serviceURL), requestURI, "ABORT ProcessInstance with id: " + processInstance.getId());
    }

    public CompletableFuture<String> retryProcessInstance(String serviceURL, ProcessInstance processInstance) {
        String requestURI = String.format(RETRY_PROCESS_INSTANCE_PATH, processInstance.getProcessId(), processInstance.getId());
        return this.sendPostClientRequest(this.getWebClient(serviceURL), requestURI, "RETRY ProcessInstance with id: " + processInstance.getId());
    }

    public CompletableFuture<String> skipProcessInstance(String serviceURL, ProcessInstance processInstance) {
        String requestURI = String.format(SKIP_PROCESS_INSTANCE_PATH, processInstance.getProcessId(), processInstance.getId());
        return this.sendPostClientRequest(this.getWebClient(serviceURL), requestURI, "SKIP ProcessInstance with id: " + processInstance.getId());
    }

    public CompletableFuture<String> updateProcessInstanceVariables(String serviceURL, ProcessInstance processInstance, String variables) {
        String requestURI = String.format(UPDATE_VARIABLES_PROCESS_INSTANCE_PATH, processInstance.getProcessId(), processInstance.getId());
        return this.sendJSONPutClientRequest(this.getWebClient(serviceURL), requestURI, "UPDATE VARIABLES of ProcessInstance with id: " + processInstance.getId(), variables);
    }

    public CompletableFuture<String> getProcessInstanceDiagram(String serviceURL, ProcessInstance processInstance) {
        String requestURI = String.format(GET_PROCESS_INSTANCE_DIAGRAM_PATH, processInstance.getProcessId(), processInstance.getId());
        return this.sendGetClientRequest(this.getWebClient(serviceURL), requestURI, "Get Process Instance diagram with id: " + processInstance.getId(), null);
    }

    public CompletableFuture<String> getProcessInstanceSourceFileContent(String serviceURL, ProcessInstance processInstance) {
        String requestURI = String.format(GET_PROCESS_INSTANCE_SOURCE_PATH, processInstance.getProcessId());
        return this.sendGetClientRequest(this.getWebClient(serviceURL), requestURI, "Get Process Instance source file with processId: " + processInstance.getProcessId(), null);
    }

    public CompletableFuture<List<Node>> getProcessInstanceNodeDefinitions(String serviceURL, ProcessInstance processInstance) {
        String requestURI = String.format(GET_PROCESS_INSTANCE_NODE_DEFINITIONS_PATH, processInstance.getProcessId());
        return this.sendGetClientRequest(this.getWebClient(serviceURL), requestURI, "Get Process Instance available nodes with id: " + processInstance.getId(), List.class);
    }

    public CompletableFuture<String> triggerNodeInstance(String serviceURL, ProcessInstance processInstance, String nodeDefinitionId) {
        String requestURI = String.format(TRIGGER_NODE_INSTANCE_PATH, processInstance.getProcessId(), processInstance.getId(), nodeDefinitionId);
        return this.sendPostClientRequest(this.getWebClient(serviceURL), requestURI, "Trigger Node " + nodeDefinitionId + "from ProcessInstance with id: " + processInstance.getId());
    }

    public CompletableFuture<String> retriggerNodeInstance(String serviceURL, ProcessInstance processInstance, String nodeInstanceId) {
        String requestURI = String.format("/management/processes/%s/instances/%s/nodeInstances/%s", processInstance.getProcessId(), processInstance.getId(), nodeInstanceId);
        return this.sendPostClientRequest(this.getWebClient(serviceURL), requestURI, "Retrigger NodeInstance " + nodeInstanceId + "from ProcessInstance with id: " + processInstance.getId());
    }

    public CompletableFuture<String> cancelNodeInstance(String serviceURL, ProcessInstance processInstance, String nodeInstanceId) {
        String requestURI = String.format("/management/processes/%s/instances/%s/nodeInstances/%s", processInstance.getProcessId(), processInstance.getId(), nodeInstanceId);
        return this.sendDeleteClientRequest(this.getWebClient(serviceURL), requestURI, "Cancel NodeInstance " + nodeInstanceId + "from ProcessInstance with id: " + processInstance.getId());
    }

    public CompletableFuture<String> cancelJob(String serviceURL, Job job) {
        String requestURI = String.format("/%s", job.getId());
        return this.sendDeleteClientRequest(this.getWebClient(serviceURL), requestURI, "CANCEL Job with id: " + job.getId());
    }

    public CompletableFuture<String> rescheduleJob(String serviceURL, Job job, String newJobData) {
        String requestURI = String.format("/%s", job.getId());
        return this.sendJSONPutClientRequest(this.getWebClient(serviceURL), requestURI, "RESCHEDULED JOB with id: " + job.getId(), newJobData);
    }

    public CompletableFuture<String> getUserTaskSchema(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups) {
        String requestURI = String.format(GET_TASK_SCHEMA_PATH, userTaskInstance.getProcessId(), userTaskInstance.getProcessInstanceId(), userTaskInstance.getName(), userTaskInstance.getId()) + "?" + this.getUserGroupsURIParameter(user, groups);
        return this.sendGetClientRequest(this.getWebClient(serviceURL), requestURI, "Get User Task schema for task:" + userTaskInstance.getName() + " with id: " + userTaskInstance.getId(), null);
    }

    public CompletableFuture<String> updateUserTaskInstance(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, Map taskInfo) {
        String requestURI = String.format(UPDATE_USER_TASK_INSTANCE_PATH, userTaskInstance.getProcessId(), userTaskInstance.getProcessInstanceId(), userTaskInstance.getId()) + "?" + this.getUserGroupsURIParameter(user, groups);
        return this.sendPatchClientRequest(this.getWebClient(serviceURL), requestURI, "Update user task instance:" + userTaskInstance.getName() + " with id: " + userTaskInstance.getId(), new JsonObject(taskInfo));
    }

    public CompletableFuture<String> createUserTaskInstanceComment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String commentInfo) {
        String requestURI = String.format(CREATE_USER_TASK_INSTANCE_COMMENT_PATH, userTaskInstance.getProcessId(), userTaskInstance.getProcessInstanceId(), userTaskInstance.getName(), userTaskInstance.getId()) + "?" + this.getUserGroupsURIParameter(user, groups);
        return this.sendPostWithBodyClientRequest(this.getWebClient(serviceURL), requestURI, "Adding comment to  UserTask:" + userTaskInstance.getName() + " with id: " + userTaskInstance.getId(), commentInfo, "text/plain");
    }

    public CompletableFuture<String> updateUserTaskInstanceComment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String commentId, String commentInfo) {
        String requestURI = String.format("/%s/%s/%s/%s/comments/%s", userTaskInstance.getProcessId(), userTaskInstance.getProcessInstanceId(), userTaskInstance.getName(), userTaskInstance.getId(), commentId) + "?" + this.getUserGroupsURIParameter(user, groups);
        return this.sendPutClientRequest(this.getWebClient(serviceURL), requestURI, "Update UserTask: " + userTaskInstance.getName() + " comment:" + commentId + "  with taskid: " + userTaskInstance.getId(), commentInfo, "text/plain");
    }

    public CompletableFuture<String> deleteUserTaskInstanceComment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String commentId) {
        String requestURI = String.format("/%s/%s/%s/%s/comments/%s", userTaskInstance.getProcessId(), userTaskInstance.getProcessInstanceId(), userTaskInstance.getName(), userTaskInstance.getId(), commentId) + "?" + this.getUserGroupsURIParameter(user, groups);
        return this.sendDeleteClientRequest(this.getWebClient(serviceURL), requestURI, "Delete comment : " + commentId + "of Task: " + userTaskInstance.getName() + "  with taskid: " + userTaskInstance.getId());
    }

    public CompletableFuture<String> createUserTaskInstanceAttachment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String name, String uri) {
        String requestURI = String.format(CREATE_USER_TASK_INSTANCE_ATTACHMENT_PATH, userTaskInstance.getProcessId(), userTaskInstance.getProcessInstanceId(), userTaskInstance.getName(), userTaskInstance.getId()) + "?" + this.getUserGroupsURIParameter(user, groups);
        return this.sendPostWithBodyClientRequest(this.getWebClient(serviceURL), requestURI, "Adding attachment to  UserTask:" + userTaskInstance.getName() + " with id: " + userTaskInstance.getId(), "{ \"name\": \"" + name + "\", \"uri\": \"" + uri + "\" }", "application/json");
    }

    public CompletableFuture<String> updateUserTaskInstanceAttachment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String attachmentId, String name, String uri) {
        String requestURI = String.format("/%s/%s/%s/%s/attachments/%s", userTaskInstance.getProcessId(), userTaskInstance.getProcessInstanceId(), userTaskInstance.getName(), userTaskInstance.getId(), attachmentId) + "?" + this.getUserGroupsURIParameter(user, groups);
        return this.sendJSONPutClientRequest(this.getWebClient(serviceURL), requestURI, "Update UserTask: " + userTaskInstance.getName() + " attachment:" + attachmentId + " with taskid: " + userTaskInstance.getId() + "with: " + name + " and info:" + uri, "{ \"name\": \"" + name + "\", \"uri\": \"" + uri + "\" }");
    }

    public CompletableFuture<String> deleteUserTaskInstanceAttachment(String serviceURL, UserTaskInstance userTaskInstance, String user, List<String> groups, String attachmentId) {
        String requestURI = String.format("/%s/%s/%s/%s/attachments/%s", userTaskInstance.getProcessId(), userTaskInstance.getProcessInstanceId(), userTaskInstance.getName(), userTaskInstance.getId(), attachmentId) + "?" + this.getUserGroupsURIParameter(user, groups);
        return this.sendDeleteClientRequest(this.getWebClient(serviceURL), requestURI, "Delete attachment : " + attachmentId + "of Task: " + userTaskInstance.getName() + "  with taskid: " + userTaskInstance.getId());
    }

    private String getUserGroupsURIParameter(String user, List<String> groups) {
        StringBuilder builder = new StringBuilder();
        if (user != null && groups != null) {
            builder.append("user=" + user);
            groups.stream().forEach(group -> builder.append("&group=" + group));
        }
        return builder.toString();
    }

    protected CompletableFuture sendDeleteClientRequest(WebClient webClient, String requestURI, String logMessage) {
        CompletableFuture future = new CompletableFuture();
        webClient.delete(requestURI).putHeader("Authorization", this.getAuthHeader()).send(res -> this.asyncHttpResponseTreatment((AsyncResult<HttpResponse<Buffer>>)res, future, logMessage));
        return future;
    }

    protected CompletableFuture sendPostWithBodyClientRequest(WebClient webClient, String requestURI, String logMessage, String body, String contentType) {
        CompletableFuture future = new CompletableFuture();
        HttpRequest request = webClient.post(requestURI).putHeader("Authorization", this.getAuthHeader()).putHeader("Content-Type", contentType);
        if ("application/json".equals(contentType)) {
            request.sendJson((Object)new JsonObject(body), res -> this.asyncHttpResponseTreatment((AsyncResult<HttpResponse<Buffer>>)res, future, logMessage));
        } else {
            request.sendBuffer(Buffer.buffer((String)body), res -> this.asyncHttpResponseTreatment((AsyncResult<HttpResponse<Buffer>>)res, future, logMessage));
        }
        return future;
    }

    private void asyncHttpResponseTreatment(AsyncResult<HttpResponse<Buffer>> res, CompletableFuture future, String logMessage) {
        if (res.succeeded() && (((HttpResponse)res.result()).statusCode() == 200 || ((HttpResponse)res.result()).statusCode() == 201)) {
            future.complete(((HttpResponse)res.result()).bodyAsString() != null ? ((HttpResponse)res.result()).bodyAsString() : "Successfully performed: " + logMessage);
        } else {
            future.completeExceptionally((Throwable)new DataIndexServiceException(this.getErrorMessage(logMessage, (HttpResponse<Buffer>)((HttpResponse)res.result()))));
        }
    }

    protected CompletableFuture sendPostClientRequest(WebClient webClient, String requestURI, String logMessage) {
        CompletableFuture future = new CompletableFuture();
        webClient.post(requestURI).putHeader("Authorization", this.getAuthHeader()).send(res -> this.asyncHttpResponseTreatment((AsyncResult<HttpResponse<Buffer>>)res, future, logMessage));
        return future;
    }

    protected CompletableFuture sendJSONPutClientRequest(WebClient webClient, String requestURI, String logMessage, String jsonString) {
        return this.sendPutClientRequest(webClient, requestURI, logMessage, jsonString, "application/json");
    }

    protected CompletableFuture sendPutClientRequest(WebClient webClient, String requestURI, String logMessage, String body, String contentType) {
        CompletableFuture future = new CompletableFuture();
        HttpRequest request = webClient.put(requestURI).putHeader("Authorization", this.getAuthHeader()).putHeader("Content-Type", contentType);
        if ("application/json".equals(contentType)) {
            request.sendJson((Object)new JsonObject(body), res -> this.asyncHttpResponseTreatment((AsyncResult<HttpResponse<Buffer>>)res, future, logMessage));
        } else {
            request.sendBuffer(Buffer.buffer((String)body), res -> this.asyncHttpResponseTreatment((AsyncResult<HttpResponse<Buffer>>)res, future, logMessage));
        }
        return future;
    }

    protected CompletableFuture sendPatchClientRequest(WebClient webClient, String requestURI, String logMessage, JsonObject jsonBody) {
        CompletableFuture future = new CompletableFuture();
        webClient.patch(requestURI).putHeader("Authorization", this.getAuthHeader()).sendJson((Object)jsonBody, res -> this.asyncHttpResponseTreatment((AsyncResult<HttpResponse<Buffer>>)res, future, logMessage));
        return future;
    }

    protected CompletableFuture sendGetClientRequest(WebClient webClient, String requestURI, String logMessage, Class type) {
        CompletableFuture future = new CompletableFuture();
        webClient.get(requestURI).putHeader("Authorization", this.getAuthHeader()).send(res -> this.send(logMessage, type, future, (AsyncResult<HttpResponse<Buffer>>)res));
        return future;
    }

    protected void send(String logMessage, Class type, CompletableFuture future, AsyncResult<HttpResponse<Buffer>> res) {
        if (res.succeeded() && ((HttpResponse)res.result()).statusCode() == 200) {
            if (type != null) {
                future.complete(((HttpResponse)res.result()).bodyAsJson(type));
            } else {
                future.complete(((HttpResponse)res.result()).bodyAsString());
            }
        } else if (res.succeeded() && ((HttpResponse)res.result()).statusCode() == 404) {
            future.complete(null);
        } else {
            future.completeExceptionally((Throwable)new DataIndexServiceException(this.getErrorMessage(logMessage, (HttpResponse<Buffer>)((HttpResponse)res.result())), res.cause()));
        }
    }

    private String getErrorMessage(String logMessage, HttpResponse<Buffer> result) {
        String errorMessage = "FAILED: " + logMessage;
        if (result != null) {
            errorMessage = errorMessage + " errorCode:" + result.statusCode() + " errorStatus:" + result.statusMessage() + " errorMessage:" + (result.body() != null ? ((Buffer)result.body()).toString() : "-");
        }
        return errorMessage;
    }

    protected String getAuthHeader() {
        if (this.identity != null && this.identity.getCredential(TokenCredential.class) != null) {
            return "Bearer " + ((TokenCredential)this.identity.getCredential(TokenCredential.class)).getToken();
        }
        return "";
    }
}

