/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service.messaging;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.smallrye.reactive.messaging.MessageConverter;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.event.process.ProcessInstanceEventBody;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceEventBody;
import org.kie.kogito.index.event.KogitoJobCloudEvent;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.service.DataIndexServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KogitoIndexEventConverter
implements MessageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoIndexEventConverter.class);
    ObjectMapper objectMapper;

    public boolean canConvert(Message<?> message, Type type) {
        return this.isIndexable(type) && message.getPayload() instanceof Buffer;
    }

    private boolean isIndexable(Type type) {
        return type == ProcessInstanceDataEvent.class || type == UserTaskInstanceDataEvent.class || type == KogitoJobCloudEvent.class;
    }

    public Message<?> convert(Message<?> message, Type type) {
        try {
            if (type.getTypeName().equals(ProcessInstanceDataEvent.class.getTypeName())) {
                ProcessInstanceDataEvent processInstanceDataEvent = (ProcessInstanceDataEvent)this.objectMapper.readValue(message.getPayload().toString(), ProcessInstanceDataEvent.class);
                if (processInstanceDataEvent.getData() == null) {
                    processInstanceDataEvent.setData((Object)((ProcessInstanceEventBody)this.objectMapper.readValue(message.getPayload().toString(), ProcessInstanceEventBody.class)));
                }
                return message.withPayload((Object)processInstanceDataEvent);
            }
            if (type.getTypeName().equals(KogitoJobCloudEvent.class.getTypeName())) {
                KogitoJobCloudEvent event = (KogitoJobCloudEvent)this.objectMapper.readValue(message.getPayload().toString(), KogitoJobCloudEvent.class);
                if (event.getData() == null) {
                    event.setData((Job)this.objectMapper.readValue(message.getPayload().toString(), Job.class));
                }
                return message.withPayload((Object)event);
            }
            if (type.getTypeName().equals(UserTaskInstanceDataEvent.class.getTypeName())) {
                UserTaskInstanceDataEvent userTaskInstanceDataEvent = (UserTaskInstanceDataEvent)this.objectMapper.readValue(message.getPayload().toString(), UserTaskInstanceDataEvent.class);
                if (userTaskInstanceDataEvent.getData() == null) {
                    userTaskInstanceDataEvent.setData((Object)((UserTaskInstanceEventBody)this.objectMapper.readValue(message.getPayload().toString(), UserTaskInstanceEventBody.class)));
                }
                return message.withPayload((Object)userTaskInstanceDataEvent);
            }
            return message;
        }
        catch (IOException e) {
            LOGGER.error("Error converting message payload to " + type.getTypeName(), (Throwable)e);
            throw new DataIndexServiceException("Error converting message payload:\n" + message.getPayload() + " \n to" + type.getTypeName(), (Throwable)e);
        }
    }

    @Inject
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

