/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.util.Set;
import java.util.function.Function;
import org.kie.kogito.event.process.UserTaskInstanceDataEvent;
import org.kie.kogito.event.process.UserTaskInstanceEventBody;
import org.kie.kogito.index.json.JsonUtils;

public class UserTaskInstanceMetaMapper
implements Function<UserTaskInstanceDataEvent, ObjectNode> {
    @Override
    public ObjectNode apply(UserTaskInstanceDataEvent event) {
        if (event == null) {
            return null;
        }
        ObjectNode json = JsonUtils.getObjectMapper().createObjectNode();
        json.put("id", Strings.isNullOrEmpty((String)((UserTaskInstanceEventBody)event.getData()).getRootProcessInstanceId()) ? ((UserTaskInstanceEventBody)event.getData()).getProcessInstanceId() : ((UserTaskInstanceEventBody)event.getData()).getRootProcessInstanceId());
        json.put("processId", Strings.isNullOrEmpty((String)((UserTaskInstanceEventBody)event.getData()).getRootProcessId()) ? ((UserTaskInstanceEventBody)event.getData()).getProcessId() : ((UserTaskInstanceEventBody)event.getData()).getRootProcessId());
        ObjectNode kogito = JsonUtils.getObjectMapper().createObjectNode();
        kogito.put("lastUpdate", event.getTime() == null ? null : Long.valueOf(event.getTime().toInstant().toEpochMilli()));
        kogito.withArray("userTasks").add((JsonNode)this.getUserTaskJson(event));
        json.set("metadata", (JsonNode)kogito);
        return json;
    }

    private ObjectNode getUserTaskJson(UserTaskInstanceDataEvent event) {
        ObjectNode json = JsonUtils.getObjectMapper().createObjectNode();
        json.put("id", ((UserTaskInstanceEventBody)event.getData()).getId());
        json.put("processInstanceId", ((UserTaskInstanceEventBody)event.getData()).getProcessInstanceId());
        json.put("state", ((UserTaskInstanceEventBody)event.getData()).getState());
        if (!Strings.isNullOrEmpty((String)((UserTaskInstanceEventBody)event.getData()).getTaskDescription())) {
            json.put("description", ((UserTaskInstanceEventBody)event.getData()).getTaskDescription());
        }
        if (!Strings.isNullOrEmpty((String)((UserTaskInstanceEventBody)event.getData()).getTaskName())) {
            json.put("name", ((UserTaskInstanceEventBody)event.getData()).getTaskName());
        }
        if (!Strings.isNullOrEmpty((String)((UserTaskInstanceEventBody)event.getData()).getTaskPriority())) {
            json.put("priority", ((UserTaskInstanceEventBody)event.getData()).getTaskPriority());
        }
        if (!Strings.isNullOrEmpty((String)((UserTaskInstanceEventBody)event.getData()).getActualOwner())) {
            json.put("actualOwner", ((UserTaskInstanceEventBody)event.getData()).getActualOwner());
        }
        this.mapArray("adminUsers", ((UserTaskInstanceEventBody)event.getData()).getAdminUsers(), json);
        this.mapArray("adminGroups", ((UserTaskInstanceEventBody)event.getData()).getAdminGroups(), json);
        this.mapArray("excludedUsers", ((UserTaskInstanceEventBody)event.getData()).getExcludedUsers(), json);
        this.mapArray("potentialGroups", ((UserTaskInstanceEventBody)event.getData()).getPotentialGroups(), json);
        this.mapArray("potentialUsers", ((UserTaskInstanceEventBody)event.getData()).getPotentialUsers(), json);
        if (((UserTaskInstanceEventBody)event.getData()).getCompleteDate() != null) {
            json.put("completed", ((UserTaskInstanceEventBody)event.getData()).getCompleteDate().toInstant().toEpochMilli());
        }
        if (((UserTaskInstanceEventBody)event.getData()).getStartDate() != null) {
            json.put("started", ((UserTaskInstanceEventBody)event.getData()).getStartDate().toInstant().toEpochMilli());
        }
        json.put("lastUpdate", event.getTime() == null ? null : Long.valueOf(event.getTime().toInstant().toEpochMilli()));
        return json;
    }

    private void mapArray(String attribute, Set<String> strings, ObjectNode json) {
        if (strings != null && !strings.isEmpty()) {
            ArrayNode array = json.withArray(attribute);
            strings.forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
        }
    }
}

