/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;

@ApplicationScoped
public class GraphQLScalarTypeProducer {
    public static ZonedDateTime parseDateTime(String s) {
        try {
            return ZonedDateTime.parse(s, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            throw new CoercingSerializeException("Invalid ISO-8601 value : '" + s + "'. because of : '" + e.getMessage() + "'");
        }
    }

    public String formatDateTime(ZonedDateTime dateTime) {
        try {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTime);
        }
        catch (DateTimeException e) {
            throw new CoercingSerializeException("Unable to turn TemporalAccessor into OffsetDateTime because of : '" + e.getMessage() + "'.");
        }
    }

    @Produces
    public GraphQLScalarType dateTimeScalar() {
        return GraphQLScalarType.newScalar().name("DateTime").description("An ISO-8601 compliant DateTime Scalar").coercing(new Coercing(){

            public Object serialize(Object input) {
                ZonedDateTime dateTime;
                if (input instanceof ZonedDateTime) {
                    dateTime = (ZonedDateTime)input;
                } else if (input instanceof String) {
                    try {
                        dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(input.toString())), ZoneOffset.UTC);
                    }
                    catch (NumberFormatException ex) {
                        dateTime = GraphQLScalarTypeProducer.parseDateTime(input.toString());
                    }
                } else if (input instanceof Long) {
                    dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli((Long)input), ZoneOffset.UTC);
                } else {
                    throw new CoercingSerializeException("Expected something we can convert to 'java.time.OffsetDateTime' but was '" + (input == null ? "null" : input.getClass().getName()) + "'.");
                }
                return GraphQLScalarTypeProducer.this.formatDateTime(dateTime);
            }

            public Object parseValue(Object input) {
                return input == null ? null : Long.valueOf(this.getDateTimeAsLong((String)input));
            }

            private long getDateTimeAsLong(String input) {
                return GraphQLScalarTypeProducer.parseDateTime(input).truncatedTo(ChronoUnit.MILLIS).toInstant().toEpochMilli();
            }

            public Object parseLiteral(Object input) {
                if (input instanceof StringValue) {
                    return this.getDateTimeAsLong(((StringValue)input).getValue());
                }
                return null;
            }
        }).build();
    }
}

