/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import io.quarkus.arc.properties.IfBuildProperty;
import io.smallrye.reactive.messaging.annotations.Blocking;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.kie.kogito.index.event.KogitoCloudEvent;
import org.kie.kogito.index.event.KogitoJobCloudEvent;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.service.IndexingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@IfBuildProperty(name="kogito.data-index.blocking", stringValue="true")
public class BlockingMessagingEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingMessagingEventConsumer.class);
    @Inject
    Event<KogitoCloudEvent> eventPublisher;
    @Inject
    IndexingService indexingService;

    @Incoming(value="kogito-processinstances-events")
    @Blocking
    @Transactional
    public void onProcessInstanceEvent(KogitoProcessCloudEvent event) {
        LOGGER.debug("Process instance consumer received KogitoCloudEvent: \n{}", (Object)event);
        this.indexingService.indexProcessInstance((ProcessInstance)event.getData());
        this.eventPublisher.fire((Object)event);
    }

    @Incoming(value="kogito-usertaskinstances-events")
    @Blocking
    @Transactional
    public void onUserTaskInstanceEvent(KogitoUserTaskCloudEvent event) {
        LOGGER.debug("Task instance received KogitoUserTaskCloudEvent \n{}", (Object)event);
        this.indexingService.indexUserTaskInstance((UserTaskInstance)event.getData());
        this.eventPublisher.fire((Object)event);
    }

    @Incoming(value="kogito-jobs-events")
    @Blocking
    @Transactional
    public void onJobEvent(KogitoJobCloudEvent event) {
        LOGGER.debug("Job received KogitoJobCloudEvent \n{}", (Object)event);
        this.indexingService.indexJob((Job)event.getData());
    }
}

