/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkus.arc.Lock;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.index.event.KogitoCloudEvent;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.json.ProcessInstanceMetaMapper;
import org.kie.kogito.index.json.UserTaskInstanceMetaMapper;
import org.kie.kogito.index.service.IndexingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Lock
public class DomainEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainEventConsumer.class);
    @ConfigProperty(name="kogito.data-index.domain-indexing", defaultValue="true")
    Boolean indexDomain;
    @Inject
    IndexingService indexingService;

    public void onDomainEvent(@Observes KogitoCloudEvent event) {
        if (!this.indexDomain.booleanValue()) {
            return;
        }
        LOGGER.debug("Processing domain event: {}", (Object)event);
        this.indexingService.indexModel(this.getDomainData(event));
    }

    private ObjectNode getDomainData(KogitoCloudEvent event) {
        if (event instanceof KogitoProcessCloudEvent) {
            return new ProcessInstanceMetaMapper().apply((KogitoProcessCloudEvent)event);
        }
        if (event instanceof KogitoUserTaskCloudEvent) {
            return new UserTaskInstanceMetaMapper().apply((KogitoUserTaskCloudEvent)event);
        }
        throw new IllegalArgumentException(String.format("Unknown message type: '%s' for event class: '%s'", event.getType(), event.getClass().getName()));
    }
}

