/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import io.quarkus.arc.properties.UnlessBuildProperty;
import io.smallrye.mutiny.Uni;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.kie.kogito.index.event.KogitoCloudEvent;
import org.kie.kogito.index.event.KogitoJobCloudEvent;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.service.IndexingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@UnlessBuildProperty(name="kogito.data-index.blocking", stringValue="true", enableIfMissing=true)
public class ReactiveMessagingEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMessagingEventConsumer.class);
    public static final String KOGITO_PROCESSINSTANCES_EVENTS = "kogito-processinstances-events";
    public static final String KOGITO_USERTASKINSTANCES_EVENTS = "kogito-usertaskinstances-events";
    public static final String KOGITO_JOBS_EVENTS = "kogito-jobs-events";
    @Inject
    IndexingService indexingService;
    @Inject
    Event<KogitoCloudEvent> eventPublisher;

    @Incoming(value="kogito-processinstances-events")
    public Uni<Void> onProcessInstanceEvent(KogitoProcessCloudEvent event) {
        LOGGER.debug("Process instance consumer received KogitoCloudEvent: \n{}", (Object)event);
        return Uni.createFrom().item((Object)event).invoke(e -> this.indexingService.indexProcessInstance((ProcessInstance)e.getData())).invoke(e -> this.eventPublisher.fire(e)).onFailure().invoke(t -> LOGGER.error("Error processing process instance KogitoCloudEvent: {}", (Object)t.getMessage(), t)).onItem().ignore().andContinueWithNull();
    }

    @Incoming(value="kogito-usertaskinstances-events")
    public Uni<Void> onUserTaskInstanceEvent(KogitoUserTaskCloudEvent event) {
        LOGGER.debug("Task instance received KogitoUserTaskCloudEvent \n{}", (Object)event);
        return Uni.createFrom().item((Object)event).invoke(e -> this.indexingService.indexUserTaskInstance((UserTaskInstance)e.getData())).invoke(e -> this.eventPublisher.fire(e)).onFailure().invoke(t -> LOGGER.error("Error processing task instance KogitoUserTaskCloudEvent: {}", (Object)t.getMessage(), t)).onItem().ignore().andContinueWithNull();
    }

    @Incoming(value="kogito-jobs-events")
    public Uni<Void> onJobEvent(KogitoJobCloudEvent event) {
        LOGGER.debug("Job received KogitoJobCloudEvent \n{}", (Object)event);
        return Uni.createFrom().item((Object)event).onItem().invoke(e -> this.indexingService.indexJob((Job)e.getData())).onFailure().invoke(t -> LOGGER.error("Error processing job KogitoJobCloudEvent: {}", (Object)t.getMessage(), t)).onItem().ignore().andContinueWithNull();
    }
}

