/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class KeycloakServerTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakServerTestResource.class);
    private static final String KEYCLOAK_VERSION = System.getProperty("keycloak.version");
    private GenericContainer keycloak;

    public Map<String, String> start() {
        if (KEYCLOAK_VERSION == null) {
            throw new RuntimeException("Please define a valid Keycloak image version in system property keycloak.version");
        }
        LOGGER.info("Using Keycloak image version: {}", (Object)KEYCLOAK_VERSION);
        this.keycloak = new FixedHostPortGenericContainer("quay.io/keycloak/keycloak:" + KEYCLOAK_VERSION).withFixedExposedPort(8281, 8080).withEnv("KEYCLOAK_USER", "admin").withEnv("KEYCLOAK_PASSWORD", "admin").withEnv("KEYCLOAK_IMPORT", "/tmp/realm.json").withClasspathResourceMapping("kogito-realm.json", "/tmp/realm.json", BindMode.READ_ONLY).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forHttp((String)"/auth"));
        this.keycloak.start();
        return Collections.emptyMap();
    }

    public void stop() {
        this.keycloak.stop();
    }
}

