/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.graphql.GraphQLSchemaManager;
import org.kie.kogito.index.infinispan.protostream.ProtobufService;

@QuarkusTest
public class GraphQLQueryOrderByTest {
    @Inject
    GraphQLSchemaManager manager;
    @Inject
    ProtobufService protobufService;

    @Test
    public void testProcessInstancesSort() {
        this.testSortBy("ProcessInstances");
    }

    @Test
    public void testProcessInstancesSortByMultipleFields() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances(orderBy: {start: ASC, processId: DESC}){ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data.ProcessInstances", CoreMatchers.isA(Collection.class), new Object[0]);
    }

    @Test
    public void testUserTaskInstancesSort() {
        this.testSortBy("UserTaskInstances");
    }

    @Test
    public void testJobsSort() {
        this.testSortBy("Jobs");
    }

    @Test
    public void testTravelsSort() throws Exception {
        this.protobufService.registerProtoBufferType(TestUtils.getTravelsProtoBufferFile());
        this.testSortBy("Travels");
    }

    private void testSortBy(String root) {
        GraphQLObjectType queryType = this.manager.getGraphQLSchema().getQueryType();
        GraphQLFieldDefinition pi = queryType.getFieldDefinition(root);
        GraphQLArgument sortBy = pi.getArgument("orderBy");
        sortBy.getChildren().forEach(type -> {
            List<String> collect = type.getChildren().stream().flatMap(this.getAllTypes()).collect(Collectors.toList());
            collect.forEach(p -> {
                this.querySortBy(root, (String)p, "ASC");
                this.querySortBy(root, (String)p, "DESC");
            });
        });
    }

    private Function<GraphQLType, Stream<String>> getAllTypes() {
        return type -> type.getChildren().stream().flatMap(t -> {
            if (t instanceof GraphQLInputObjectType) {
                return this.getAllTypes().apply((GraphQLType)t).map(s -> String.format("%s : { %s }", type.getName(), s));
            }
            if (t instanceof GraphQLInputObjectField) {
                if (((GraphQLInputObjectField)t).getType() instanceof GraphQLInputObjectType) {
                    return this.getAllTypes().apply((GraphQLType)((GraphQLInputObjectField)t).getType()).map(s -> String.format("%s : { %s }", t.getName(), s));
                }
                return Stream.of(String.format("%s : $sort", t.getName()));
            }
            return Stream.of(String.format("%s : $sort", type.getName()));
        });
    }

    private void querySortBy(String root, String property, String sort) {
        String body = String.format("{ \"query\" : \"query ($sort: OrderBy) { %s( orderBy: { %s } ) { id } }\", \"variables\" : { \"sort\" : \"%s\" } }", root, property, sort);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(body).when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200)).body("data." + root, CoreMatchers.isA(Collection.class), new Object[0]);
    }
}

