/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.eclipse.microprofile.config.ConfigProvider;
import org.kie.kogito.index.event.KogitoJobCloudEvent;
import org.kie.kogito.index.event.KogitoProcessCloudEvent;
import org.kie.kogito.index.event.KogitoUserTaskCloudEvent;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.MilestoneStatus;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceError;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;

public final class TestUtils {
    private TestUtils() {
    }

    public static int getPortFromConfig() {
        return ConfigProvider.getConfig().getOptionalValue("quarkus.https.test-port", Integer.class).orElse(8081);
    }

    public static String getDealsProtoBufferFile() throws Exception {
        return TestUtils.readFileContent("deals.proto");
    }

    public static String getTravelsProtoBufferFile() throws Exception {
        return TestUtils.readFileContent("travels.proto");
    }

    public static String readFileContent(String file) throws URISyntaxException, IOException {
        Path path = Paths.get(Thread.currentThread().getContextClassLoader().getResource(file).toURI());
        return new String(Files.readAllBytes(path));
    }

    public static KogitoProcessCloudEvent getProcessCloudEvent(String processId, String processInstanceId, ProcessInstanceState status, String rootProcessInstanceId, String rootProcessId, String parentProcessInstanceId) {
        return (KogitoProcessCloudEvent)((KogitoProcessCloudEvent.Builder)((KogitoProcessCloudEvent.Builder)((KogitoProcessCloudEvent.Builder)((KogitoProcessCloudEvent.Builder)((KogitoProcessCloudEvent.Builder)((KogitoProcessCloudEvent.Builder)((KogitoProcessCloudEvent.Builder)((KogitoProcessCloudEvent.Builder)((KogitoProcessCloudEvent.Builder)((KogitoProcessCloudEvent.Builder)((KogitoProcessCloudEvent.Builder)KogitoProcessCloudEvent.builder().id(UUID.randomUUID().toString())).rootProcessInstanceId(rootProcessInstanceId)).rootProcessId(rootProcessId)).parentProcessInstanceId(parentProcessInstanceId).processId(processId)).state(Integer.valueOf(status.ordinal())).contentType("application/json")).processInstanceId(processInstanceId)).type("ProcessInstanceEvent")).data((Object)TestUtils.getProcessInstance(processId, processInstanceId, status.ordinal(), rootProcessInstanceId, rootProcessId))).kogitoReferenceId(UUID.randomUUID().toString()).schemaURL(URI.create("kogito"))).source(URI.create("http://localhost:8080/" + processId))).kogitoAddons("jobs-management,prometheus-monitoring,process-management").time(ZonedDateTime.now())).build();
    }

    public static ProcessInstance getProcessInstance(String processId, String processInstanceId, Integer status, String rootProcessInstanceId, String rootProcessId) {
        ProcessInstance pi = new ProcessInstance();
        pi.setId(processInstanceId);
        pi.setProcessId(processId);
        pi.setProcessName(RandomStringUtils.randomAlphabetic((int)10));
        pi.setRootProcessInstanceId(rootProcessInstanceId);
        pi.setParentProcessInstanceId(rootProcessInstanceId);
        pi.setRootProcessId(rootProcessId);
        pi.setRoles(Collections.singleton("admin"));
        pi.setVariables(TestUtils.getProcessInstanceVariables());
        pi.setNodes(TestUtils.getNodeInstances());
        pi.setState(status);
        pi.setStart(ZonedDateTime.now());
        pi.setEnd(status.intValue() == ProcessInstanceState.COMPLETED.ordinal() ? ZonedDateTime.now().plus(1L, ChronoUnit.HOURS) : null);
        if (ProcessInstanceState.ERROR.ordinal() == status.intValue()) {
            pi.setError(new ProcessInstanceError("StartEvent_1", "Something went wrong"));
        }
        pi.setMilestones(TestUtils.getMilestones());
        return pi;
    }

    private static List<NodeInstance> getNodeInstances() {
        NodeInstance ni = new NodeInstance();
        ni.setId(UUID.randomUUID().toString());
        ni.setEnter(ZonedDateTime.now());
        ni.setName("Start");
        ni.setType("StartNode");
        ni.setNodeId("1");
        ni.setDefinitionId("StartEvent_1");
        return Lists.newArrayList((Object[])new NodeInstance[]{ni});
    }

    private static List<Milestone> getMilestones() {
        return Lists.newArrayList((Object[])new Milestone[]{Milestone.builder().id(UUID.randomUUID().toString()).name("SimpleMilestone").status(MilestoneStatus.AVAILABLE.name()).build()});
    }

    private static JsonNode getProcessInstanceVariables() {
        HashMap json = new HashMap();
        HashMap<String, String> traveller = new HashMap<String, String>();
        traveller.put("firstName", "Maciej");
        json.put("traveller", traveller);
        HashMap<String, String> hotel = new HashMap<String, String>();
        hotel.put("name", "Meriton");
        json.put("hotel", hotel);
        HashMap<String, String> flight = new HashMap<String, String>();
        flight.put("flightNumber", "MX555");
        flight.put("arrival", "2019-08-20T22:12:57.340Z");
        flight.put("departure", "2019-08-20T07:12:57.340Z");
        json.put("flight", flight);
        return JsonUtils.getObjectMapper().valueToTree(json);
    }

    public static KogitoUserTaskCloudEvent getUserTaskCloudEvent(String taskId, String processId, String processInstanceId, String rootProcessInstanceId, String rootProcessId, String state) {
        return (KogitoUserTaskCloudEvent)((KogitoUserTaskCloudEvent.Builder)((KogitoUserTaskCloudEvent.Builder)((KogitoUserTaskCloudEvent.Builder)((KogitoUserTaskCloudEvent.Builder)((KogitoUserTaskCloudEvent.Builder)((KogitoUserTaskCloudEvent.Builder)((KogitoUserTaskCloudEvent.Builder)((KogitoUserTaskCloudEvent.Builder)((KogitoUserTaskCloudEvent.Builder)((KogitoUserTaskCloudEvent.Builder)KogitoUserTaskCloudEvent.builder().id(UUID.randomUUID().toString())).userTaskInstanceId(taskId).rootProcessInstanceId(rootProcessInstanceId)).rootProcessId(rootProcessId)).processId(processId)).contentType("application/json")).processInstanceId(processInstanceId)).type("UserTaskInstanceEvent")).source(URI.create("http://localhost:8080/"))).data((Object)TestUtils.getUserTaskInstance(taskId, processId, processInstanceId, rootProcessInstanceId, rootProcessId, state))).time(ZonedDateTime.now())).build();
    }

    public static KogitoJobCloudEvent getJobCloudEvent(String jobId, String processId, String processInstanceId, String rootProcessInstanceId, String rootProcessId, String status) {
        return (KogitoJobCloudEvent)((KogitoJobCloudEvent.Builder)((KogitoJobCloudEvent.Builder)KogitoJobCloudEvent.builder().id(UUID.randomUUID().toString())).data((Object)TestUtils.getJob(jobId, processId, processInstanceId, rootProcessId, rootProcessInstanceId, status))).build();
    }

    private static Job getJob(String jobId, String processId, String processInstanceId, String rootProcessId, String rootProcessInstanceId, String status) {
        Job job = new Job();
        job.setId(jobId);
        job.setProcessId(processId);
        job.setProcessInstanceId(processInstanceId);
        job.setRootProcessId(rootProcessId);
        job.setRootProcessInstanceId(rootProcessInstanceId);
        job.setStatus(status);
        job.setExpirationTime(ZonedDateTime.now());
        job.setPriority(Integer.valueOf(1));
        job.setCallbackEndpoint("http://service");
        job.setRepeatInterval(Long.valueOf(0L));
        job.setRepeatLimit(Integer.valueOf(-1));
        job.setScheduledId(UUID.randomUUID().toString());
        job.setRetries(Integer.valueOf(10));
        job.setLastUpdate(ZonedDateTime.now());
        job.setExecutionCounter(Integer.valueOf(2));
        return job;
    }

    private static UserTaskInstance getUserTaskInstance(String taskId, String processId, String processInstanceId, String rootProcessInstanceId, String rootProcessId, String state) {
        UserTaskInstance task = new UserTaskInstance();
        task.setId(taskId);
        task.setProcessInstanceId(processInstanceId);
        task.setProcessId(processId);
        task.setRootProcessId(rootProcessId);
        task.setRootProcessInstanceId(rootProcessInstanceId);
        task.setName("TaskName");
        task.setDescription("TaskDescription");
        task.setState(state);
        task.setPriority("High");
        task.setStarted(ZonedDateTime.now());
        task.setCompleted(ZonedDateTime.now().plus(1L, ChronoUnit.HOURS));
        task.setActualOwner("kogito");
        task.setAdminUsers(Collections.singleton("kogito"));
        task.setAdminGroups(Collections.singleton("admin"));
        task.setExcludedUsers(Collections.singleton("excluded"));
        task.setPotentialUsers(Collections.singleton("potentialUser"));
        task.setPotentialGroups(Collections.singleton("potentialGroup"));
        return task;
    }
}

