/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.cache;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.DataIndexInfinispanServerTestResource;
import org.kie.kogito.index.DataIndexStorageService;
import org.kie.kogito.index.TestUtils;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.persistence.api.Storage;

@QuarkusTest
@QuarkusTestResource(value=DataIndexInfinispanServerTestResource.class)
public class StorageIT {
    @Inject
    DataIndexStorageService cacheService;

    @Test
    public void testObjectCreatedListener() throws Exception {
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        CompletableFuture cf = new CompletableFuture();
        Storage cache = this.cacheService.getProcessInstancesCache();
        cache.addObjectCreatedListener(pi -> cf.complete(pi));
        cache.put((Object)processInstanceId, (Object)TestUtils.getProcessInstance(processId, processInstanceId, ProcessInstanceState.ACTIVE.ordinal(), null, null));
        ProcessInstance pi2 = (ProcessInstance)cf.get(1L, TimeUnit.MINUTES);
        ((ObjectAssert)Assertions.assertThat((Object)pi2).hasFieldOrPropertyWithValue("id", (Object)processInstanceId)).hasFieldOrPropertyWithValue("processId", (Object)processId);
    }

    @Test
    public void testObjectUpdatedListener() throws Exception {
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        CompletableFuture cf = new CompletableFuture();
        Storage cache = this.cacheService.getProcessInstancesCache();
        cache.addObjectUpdatedListener(pi -> cf.complete(pi));
        cache.put((Object)processInstanceId, (Object)TestUtils.getProcessInstance(processId, processInstanceId, ProcessInstanceState.ACTIVE.ordinal(), null, null));
        cache.put((Object)processInstanceId, (Object)TestUtils.getProcessInstance(processId, processInstanceId, ProcessInstanceState.COMPLETED.ordinal(), null, null));
        ProcessInstance pi2 = (ProcessInstance)cf.get(1L, TimeUnit.MINUTES);
        ((ObjectAssert)Assertions.assertThat((Object)pi2).hasFieldOrPropertyWithValue("id", (Object)processInstanceId)).hasFieldOrPropertyWithValue("state", (Object)ProcessInstanceState.COMPLETED.ordinal());
    }

    @Test
    public void testObjectRemovedListener() throws Exception {
        String processId = "travels";
        String processInstanceId = UUID.randomUUID().toString();
        CompletableFuture cf = new CompletableFuture();
        Storage cache = this.cacheService.getProcessInstancesCache();
        cache.addObjectRemovedListener(id -> cf.complete(id));
        cache.put((Object)processInstanceId, (Object)TestUtils.getProcessInstance(processId, processInstanceId, ProcessInstanceState.ACTIVE.ordinal(), null, null));
        cache.remove((Object)processInstanceId);
        String id2 = (String)cf.get(1L, TimeUnit.MINUTES);
        Assertions.assertThat((String)id2).isEqualTo(processInstanceId);
    }
}

