/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.AccessTokenResponse;
import org.kie.kogito.index.DataIndexInfinispanServerTestResource;
import org.kie.kogito.index.KeycloakServerTestResource;

@QuarkusTest
@QuarkusTestResource.List(value={@QuarkusTestResource(value=KeycloakServerTestResource.class), @QuarkusTestResource(value=DataIndexInfinispanServerTestResource.class)})
public class KeycloakIntegrationIndexingServiceIT {
    private static final String KEYCLOAK_SERVER_URL = System.getProperty("quarkus.oidc.auth-server-url", "http://localhost:8281/auth/realms/kogito");
    private static final String KEYCLOAK_CLIENT_ID = System.getProperty("quarkus.oidc.client-id", "kogito-service");
    private static final String KEYCLOAK_CLIENT_SECRET = System.getProperty("quarkus.oidc.credentials.secret", "secret");

    @Test
    public void testUnauthorizedUserAccess() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id } }\" }").auth().oauth2(this.getAccessToken("alice")).when().get("/graphql", new Object[0])).then()).statusCode(403);
    }

    @Test
    public void testNoTokenProvided() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id } }\" }").when().get("/graphql", new Object[0])).then()).statusCode(401);
    }

    @Test
    public void testAuthorizedUserProvided() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("jdoe")).contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200);
    }

    @Test
    public void graphiqlLoginOnKeycloakServedTest() {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/graphiql/", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/", new Object[0])).then()).statusCode(200);
        this.assertIsLoginPage((Response)RestAssured.given().when().get("/graphiql/", new Object[0]));
        this.assertIsLoginPage((Response)RestAssured.given().when().get("/", new Object[0]));
        this.assertIsNotLoginPage((Response)RestAssured.given().when().get("/other", new Object[0]));
        this.assertIsNotLoginPage((Response)RestAssured.given().when().get("/graphql", new Object[0]));
    }

    private void assertIsLoginPage(Response response) {
        Assertions.assertThat((String)((Response)response.andReturn()).body().asString()).contains(new CharSequence[]{"<title>Log in to kogito</title>"});
    }

    private void assertIsNotLoginPage(Response response) {
        Assertions.assertThat((String)((Response)response.andReturn()).body().asString()).doesNotContain(new CharSequence[]{"<title>Log in to kogito</title>"});
    }

    private String getAccessToken(String userName) {
        return ((AccessTokenResponse)((Response)RestAssured.given().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userName}).param("client_id", new Object[]{KEYCLOAK_CLIENT_ID}).param("client_secret", new Object[]{KEYCLOAK_CLIENT_SECRET}).when().post(KEYCLOAK_SERVER_URL + "/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }
}

