/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import graphql.schema.DataFetchingEnvironment;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.graphql.GraphQLSchemaManager;
import org.kie.kogito.index.model.ProcessInstance;
import org.mockito.Mockito;

public class GraphQLSchemaManagerTest {
    GraphQLSchemaManager schemaManager = new GraphQLSchemaManager();
    ObjectMapper objectMapper = new ObjectMapper();

    @Test
    public void testNullServiceUrl() {
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv(null, null))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("travels", null))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orders", null))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orderItems", null))).isNull();
    }

    @Test
    public void testJsonNullServiceUrl() {
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceJsonServiceUrl(this.geJsonEnv(null, null))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceJsonServiceUrl(this.geJsonEnv("travels", null))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceJsonServiceUrl(this.geJsonEnv("demo.orders", null))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceJsonServiceUrl(this.geJsonEnv("demo.orderItems", null))).isNull();
    }

    @Test
    public void testNullProcessIdServiceUrl() {
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("travels", "/travels"))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orders", "/orders"))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orderItems", "/orderItems"))).isNull();
    }

    @Test
    public void testJsonNullProcessIdServiceUrl() {
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceJsonServiceUrl(this.geJsonEnv("travels", "/travels"))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceJsonServiceUrl(this.geJsonEnv("demo.orders", "/orders"))).isNull();
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceJsonServiceUrl(this.geJsonEnv("demo.orderItems", "/orderItems"))).isNull();
    }

    @Test
    public void testUrlProcessIdServiceUrl() {
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("travels", "http://localhost:8080/travels"))).isEqualTo("http://localhost:8080");
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orders", "http://localhost:8080/orders"))).isEqualTo("http://localhost:8080");
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceServiceUrl(this.getEnv("demo.orderItems", "http://localhost:8080/orderItems"))).isEqualTo("http://localhost:8080");
    }

    @Test
    public void testJsonUrlProcessIdServiceUrl() {
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceJsonServiceUrl(this.geJsonEnv("travels", "http://localhost:8080/travels"))).isEqualTo("http://localhost:8080");
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceJsonServiceUrl(this.geJsonEnv("demo.orders", "http://localhost:8080/orders"))).isEqualTo("http://localhost:8080");
        Assertions.assertThat((String)this.schemaManager.getProcessInstanceJsonServiceUrl(this.geJsonEnv("demo.orderItems", "http://localhost:8080/orderItems"))).isEqualTo("http://localhost:8080");
    }

    private DataFetchingEnvironment geJsonEnv(String processId, String endpoint) {
        DataFetchingEnvironment env = (DataFetchingEnvironment)Mockito.mock(DataFetchingEnvironment.class);
        Mockito.when((Object)env.getSource()).thenReturn((Object)this.getProcessInstanceJson(processId, endpoint));
        return env;
    }

    private DataFetchingEnvironment getEnv(String processId, String endpoint) {
        DataFetchingEnvironment env = (DataFetchingEnvironment)Mockito.mock(DataFetchingEnvironment.class);
        Mockito.when((Object)env.getSource()).thenReturn((Object)this.getProcessInstance(processId, endpoint));
        return env;
    }

    private JsonNode getProcessInstanceJson(String processId, String endpoint) {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        objectNode.put("processId", processId);
        objectNode.put("endpoint", endpoint);
        return objectNode;
    }

    private ProcessInstance getProcessInstance(String processId, String endpoint) {
        ProcessInstance pi = new ProcessInstance();
        pi.setProcessId(processId);
        pi.setEndpoint(endpoint);
        return pi;
    }
}

