/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql.query;

import graphql.execution.MergedField;
import graphql.language.Argument;
import graphql.language.EnumValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.index.graphql.query.GraphQLQueryOrderByParser;
import org.kie.kogito.persistence.api.query.AttributeSort;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.mockito.Mockito;

public class GraphQLQueryOrderParserTest {
    private static DataFetchingEnvironment mockDataFetchingEnvironment(List<Argument> arguments, Map<String, Object> variables) {
        DataFetchingEnvironment env = (DataFetchingEnvironment)Mockito.mock(DataFetchingEnvironment.class);
        MergedField mergedFiled = (MergedField)Mockito.mock(MergedField.class);
        Mockito.when((Object)mergedFiled.getArguments()).thenReturn(arguments);
        Mockito.when((Object)env.getMergedField()).thenReturn((Object)mergedFiled);
        Mockito.when((Object)env.getVariables()).thenReturn(variables);
        return env;
    }

    @Test
    public void testNull() {
        Assertions.assertThat((List)new GraphQLQueryOrderByParser().apply(null)).isEmpty();
    }

    @Test
    public void testEmpty() {
        DataFetchingEnvironment env = GraphQLQueryOrderParserTest.mockDataFetchingEnvironment(Collections.emptyList(), Collections.emptyMap());
        Assertions.assertThat((List)new GraphQLQueryOrderByParser().apply(env)).isEmpty();
    }

    @Test
    public void testNonMatchingArgument() {
        DataFetchingEnvironment env = GraphQLQueryOrderParserTest.mockDataFetchingEnvironment(Collections.singletonList(Argument.newArgument().name("where").build()), Collections.emptyMap());
        Assertions.assertThat((List)new GraphQLQueryOrderByParser().apply(env)).isEmpty();
    }

    @Test
    public void testSortSingleArgument() {
        DataFetchingEnvironment env = GraphQLQueryOrderParserTest.mockDataFetchingEnvironment(Collections.singletonList(Argument.newArgument().name("orderBy").value((Value)ObjectValue.newObjectValue().objectField(ObjectField.newObjectField().name("start").value((Value)EnumValue.newEnumValue((String)"ASC").build()).build()).build()).build()), Collections.emptyMap());
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat((List)new GraphQLQueryOrderByParser().apply(env)).hasSize(1)).first()).matches(s -> s.getAttribute().equals("start"))).matches(s -> SortDirection.ASC == s.getSort());
    }

    @Test
    public void testSortUsingVariable() {
        DataFetchingEnvironment env = GraphQLQueryOrderParserTest.mockDataFetchingEnvironment(Collections.singletonList(Argument.newArgument().name("orderBy").value((Value)VariableReference.newVariableReference().name("orderBy").build()).build()), Collections.singletonMap("orderBy", Collections.singletonMap("flight", Collections.singletonMap("start", "ASC"))));
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat((List)new GraphQLQueryOrderByParser().apply(env)).hasSize(1)).first()).matches(s -> s.getAttribute().equals("flight.start"))).matches(s -> SortDirection.ASC == s.getSort());
    }

    @Test
    public void testSortArgumentOrder() {
        DataFetchingEnvironment env = GraphQLQueryOrderParserTest.mockDataFetchingEnvironment(Collections.singletonList(Argument.newArgument().name("orderBy").value((Value)ObjectValue.newObjectValue().objectFields(Arrays.asList(ObjectField.newObjectField().name("start").value((Value)EnumValue.newEnumValue((String)"ASC").build()).build(), ObjectField.newObjectField().name("end").value((Value)EnumValue.newEnumValue((String)"DESC").build()).build())).build()).build()), Collections.emptyMap());
        ((ListAssert)Assertions.assertThat((List)new GraphQLQueryOrderByParser().apply(env)).hasSize(2)).containsExactly((Object[])new AttributeSort[]{QueryFilterFactory.orderBy((String)"start", (SortDirection)SortDirection.ASC), QueryFilterFactory.orderBy((String)"end", (SortDirection)SortDirection.DESC)});
    }

    @Test
    public void testSortArgumentUsingChildEntity() {
        DataFetchingEnvironment env = GraphQLQueryOrderParserTest.mockDataFetchingEnvironment(Collections.singletonList(Argument.newArgument().name("orderBy").value((Value)ObjectValue.newObjectValue().objectFields(Arrays.asList(ObjectField.newObjectField().name("nodes").value((Value)ObjectValue.newObjectValue().objectField(ObjectField.newObjectField().name("name").value((Value)EnumValue.newEnumValue((String)"DESC").build()).build()).build()).build(), ObjectField.newObjectField().name("start").value((Value)EnumValue.newEnumValue((String)"ASC").build()).build())).build()).build()), Collections.emptyMap());
        ((ListAssert)Assertions.assertThat((List)new GraphQLQueryOrderByParser().apply(env)).hasSize(2)).containsExactly((Object[])new AttributeSort[]{QueryFilterFactory.orderBy((String)"nodes.name", (SortDirection)SortDirection.DESC), QueryFilterFactory.orderBy((String)"start", (SortDirection)SortDirection.ASC)});
    }
}

