/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index;

import com.google.common.collect.Lists;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.kie.kogito.index.event.KogitoCloudEvent;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;

public final class TestUtils {
    private TestUtils() {
    }

    public static String getTravelsProtoBufferFile() throws Exception {
        Path path = Paths.get(Thread.currentThread().getContextClassLoader().getResource("travels.proto").toURI());
        return new String(Files.readAllBytes(path));
    }

    public static KogitoCloudEvent getTravelsCloudEvent(String processId, String processInstanceId, String type, ProcessInstanceState status, String rootProcessInstanceId, String rootProcessId) throws Exception {
        return KogitoCloudEvent.builder().id(UUID.randomUUID().toString()).rootProcessInstanceId(rootProcessInstanceId).rootProcessId(rootProcessId).processId(processId).state(Integer.valueOf(status.ordinal())).contentType("application/json").processInstanceId(processInstanceId).type(type).source(URI.create("http://localhost:8080/")).time(new Date()).data(TestUtils.getProcessInstance(processId, processInstanceId, status.ordinal(), rootProcessInstanceId, rootProcessId)).build();
    }

    private static ProcessInstance getProcessInstance(String processId, String processInstanceId, Integer status, String rootProcessInstanceId, String rootProcessId) throws Exception {
        ProcessInstance pi = new ProcessInstance();
        pi.setId(processInstanceId);
        pi.setProcessId(processId);
        pi.setRootProcessInstanceId(rootProcessInstanceId);
        pi.setParentProcessInstanceId(rootProcessInstanceId);
        pi.setRootProcessId(rootProcessId);
        pi.setRoles(Collections.singleton("admin"));
        pi.setVariables(TestUtils.getProcessInstanceVariables());
        pi.setNodes(TestUtils.getNodeInstances());
        pi.setEndpoint("http://localhost:8080/");
        pi.setState(status);
        return pi;
    }

    private static List<NodeInstance> getNodeInstances() {
        NodeInstance ni = new NodeInstance();
        ni.setId(UUID.randomUUID().toString());
        ni.setEnter(new Date());
        ni.setName("Start");
        ni.setType("StartNode");
        return Lists.newArrayList((Object[])new NodeInstance[]{ni});
    }

    private static String getProcessInstanceVariables() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        HashMap<String, String> traveller = new HashMap<String, String>();
        traveller.put("firstName", "Maciej");
        builder.add("traveller", (JsonValue)Json.createObjectBuilder(traveller).build());
        HashMap<String, String> hotel = new HashMap<String, String>();
        hotel.put("name", "Meriton");
        builder.add("hotel", (JsonValue)Json.createObjectBuilder(hotel).build());
        HashMap<String, String> flight = new HashMap<String, String>();
        flight.put("flightNumber", "MX555");
        flight.put("arrival", "2019-08-20T22:12:57.340Z");
        flight.put("departure", "2019-08-20T07:12:57.340Z");
        builder.add("flight", (JsonValue)Json.createObjectBuilder(flight).build());
        return builder.build().toString();
    }
}

