/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.JsonObject;
import org.kie.kogito.index.graphql.ProcessInstanceFilterMapper;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.query.QueryService;

@ApplicationScoped
public class GraphQLSchemaManager {
    @Inject
    QueryService queryService;
    private GraphQLSchema schema;

    @PostConstruct
    public void setup() {
        this.schema = this.createSchema();
    }

    private GraphQLSchema createSchema() {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("schema.graphqls");
        SchemaParser schemaParser = new SchemaParser();
        TypeDefinitionRegistry typeDefinitionRegistry = schemaParser.parse((Reader)new InputStreamReader(stream));
        RuntimeWiring runtimeWiring = RuntimeWiring.newRuntimeWiring().type("Query", builder -> {
            builder.dataFetcher("ProcessInstances", env -> this.getProcessInstancesValues(env));
            return builder;
        }).type("ProcessInstanceState", builder -> {
            builder.enumValues(name -> ProcessInstanceState.valueOf((String)name).ordinal());
            return builder;
        }).build();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        return schemaGenerator.makeExecutableSchema(typeDefinitionRegistry, runtimeWiring);
    }

    private Collection<JsonObject> getProcessInstancesValues(DataFetchingEnvironment env) {
        Map filter = (Map)env.getArgument("filter");
        return this.queryService.queryProcessInstances(new ProcessInstanceFilterMapper().apply(filter));
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.schema;
    }

    public void transform(Consumer<GraphQLSchema.Builder> builder) {
        this.schema = this.schema.transform(builder);
    }
}

