/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.messaging;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.kie.kogito.index.event.KogitoCloudEvent;
import org.kie.kogito.index.service.IndexingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ReactiveMessagingEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMessagingEventConsumer.class);
    private static final String TOPIC = "kogito-processinstances-events";
    @Inject
    IndexingService indexingService;

    @Incoming(value="kogito-processinstances-events")
    public void onProcessInstanceEvent(KogitoCloudEvent event) {
        try {
            LOGGER.debug("Received KogitoCloudEvent \n{}", (Object)event);
            this.indexingService.indexProcessInstance(event);
            this.indexingService.indexProcessInstanceModel(event);
        }
        catch (Throwable t) {
            LOGGER.error("Error processing KogitoCloudEvent: {}", (Object)t.getMessage(), (Object)t);
        }
    }
}

