/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.graphql;

import com.fasterxml.jackson.databind.node.ObjectNode;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.quarkus.arc.Arc;
import io.vertx.axle.core.eventbus.EventBus;
import io.vertx.axle.core.eventbus.Message;
import io.vertx.axle.core.eventbus.MessageConsumer;
import io.vertx.axle.core.eventbus.MessageProducer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.index.cache.CacheService;
import org.kie.kogito.index.graphql.ProcessInstanceFilterMapper;
import org.kie.kogito.index.graphql.UserTaskInstanceFilterMapper;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceState;
import org.kie.kogito.index.model.UserTaskInstance;
import org.kie.kogito.index.query.ProcessInstanceFilter;
import org.kie.kogito.index.query.QueryService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class GraphQLSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLSchemaManager.class);
    private static final String PROCESS_INSTANCE_ADDED = "ProcessInstanceAdded";
    private static final String PROCESS_INSTANCE_UPDATED = "ProcessInstanceUpdated";
    private static final String USER_TASK_INSTANCE_ADDED = "UserTaskInstanceAdded";
    private static final String USER_TASK_INSTANCE_UPDATED = "UserTaskInstanceUpdated";
    @Inject
    QueryService queryService;
    @Inject
    CacheService cacheService;
    @Inject
    GraphQLScalarType qlDateTimeScalarType;
    private ConcurrentMap<String, MessageProducer> producers = new ConcurrentHashMap<String, MessageProducer>();
    private GraphQLSchema schema;

    @PostConstruct
    public void setup() {
        this.schema = this.createSchema();
    }

    @PreDestroy
    public void destroy() {
        this.producers.values().forEach(MessageProducer::close);
    }

    private GraphQLSchema createSchema() {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("schema.graphqls");
        SchemaParser schemaParser = new SchemaParser();
        TypeDefinitionRegistry typeDefinitionRegistry = schemaParser.parse((Reader)new InputStreamReader(stream));
        RuntimeWiring runtimeWiring = RuntimeWiring.newRuntimeWiring().type("Query", builder -> {
            builder.dataFetcher("ProcessInstances", this::getProcessInstancesValues);
            builder.dataFetcher("UserTaskInstances", this::getUserTaskInstancesValues);
            return builder;
        }).type("ProcessInstance", builder -> {
            builder.dataFetcher("childProcessInstanceId", this::getChildProcessInstancesValues);
            return builder;
        }).type("ProcessInstanceState", builder -> {
            builder.enumValues(name -> ProcessInstanceState.valueOf((String)name).ordinal());
            return builder;
        }).type("Subscription", builder -> {
            builder.dataFetcher(PROCESS_INSTANCE_ADDED, this.getProcessInstanceAddedDataFetcher());
            builder.dataFetcher(PROCESS_INSTANCE_UPDATED, this.getProcessInstanceUpdatedDataFetcher());
            builder.dataFetcher(USER_TASK_INSTANCE_ADDED, this.getUserTaskInstanceAddedDataFetcher());
            builder.dataFetcher(USER_TASK_INSTANCE_UPDATED, this.getUserTaskInstanceUpdatedDataFetcher());
            return builder;
        }).scalar(this.qlDateTimeScalarType).build();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        return schemaGenerator.makeExecutableSchema(typeDefinitionRegistry, runtimeWiring);
    }

    private Set<String> getChildProcessInstancesValues(DataFetchingEnvironment env) {
        ProcessInstance source = (ProcessInstance)env.getSource();
        Collection pil = this.queryService.queryProcessInstances(ProcessInstanceFilter.builder().parentProcessInstanceId(Collections.singletonList(source.getId())).build());
        return pil.stream().map(pi -> pi.getId()).collect(Collectors.toSet());
    }

    private Collection<ProcessInstance> getProcessInstancesValues(DataFetchingEnvironment env) {
        Map filter = (Map)env.getArgument("filter");
        return this.queryService.queryProcessInstances(new ProcessInstanceFilterMapper().apply(filter));
    }

    private Collection<UserTaskInstance> getUserTaskInstancesValues(DataFetchingEnvironment env) {
        Map filter = (Map)env.getArgument("filter");
        return this.queryService.queryUserTaskInstances(new UserTaskInstanceFilterMapper().apply(filter));
    }

    private DataFetcher<Publisher<ObjectNode>> getProcessInstanceAddedDataFetcher() {
        return env -> this.createPublisher(PROCESS_INSTANCE_ADDED, producer -> this.cacheService.getProcessInstancesCache().addObjectCreatedListener(pi -> producer.write(JsonUtils.getObjectMapper().convertValue(pi, ObjectNode.class))));
    }

    private DataFetcher<Publisher<ObjectNode>> getProcessInstanceUpdatedDataFetcher() {
        return env -> this.createPublisher(PROCESS_INSTANCE_UPDATED, producer -> this.cacheService.getProcessInstancesCache().addObjectUpdatedListener(pi -> producer.write(JsonUtils.getObjectMapper().convertValue(pi, ObjectNode.class))));
    }

    private DataFetcher<Publisher<ObjectNode>> getUserTaskInstanceAddedDataFetcher() {
        return env -> this.createPublisher(USER_TASK_INSTANCE_ADDED, producer -> this.cacheService.getUserTaskInstancesCache().addObjectCreatedListener(ut -> producer.write(JsonUtils.getObjectMapper().convertValue(ut, ObjectNode.class))));
    }

    private DataFetcher<Publisher<ObjectNode>> getUserTaskInstanceUpdatedDataFetcher() {
        return env -> this.createPublisher(USER_TASK_INSTANCE_UPDATED, producer -> this.cacheService.getUserTaskInstancesCache().addObjectUpdatedListener(ut -> producer.write(JsonUtils.getObjectMapper().convertValue(ut, ObjectNode.class))));
    }

    private Publisher<ObjectNode> createPublisher(String address, Consumer<MessageProducer<ObjectNode>> consumer) {
        EventBus eventBus = (EventBus)Arc.container().instance(EventBus.class, new Annotation[0]).get();
        LOGGER.debug("Creating new message consumer for EventBus address: {}", (Object)address);
        MessageConsumer messageConsumer = eventBus.consumer(address);
        Publisher publisher = messageConsumer.toPublisherBuilder().map(Message::body).buildRs();
        this.producers.computeIfAbsent(address, key -> {
            LOGGER.debug("Creating new message publisher for EventBus address: {}", (Object)address);
            MessageProducer producer = eventBus.publisher(address);
            consumer.accept(producer);
            return producer;
        });
        return publisher;
    }

    protected DataFetcher<Publisher<ObjectNode>> getDomainModelUpdatedDataFetcher(String processId) {
        return env -> this.createPublisher(processId + "Updated", producer -> this.cacheService.getDomainModelCache(processId).addObjectUpdatedListener(domain -> producer.write(domain)));
    }

    protected DataFetcher<Publisher<ObjectNode>> getDomainModelAddedDataFetcher(String processId) {
        return env -> this.createPublisher(processId + "Added", producer -> this.cacheService.getDomainModelCache(processId).addObjectCreatedListener(domain -> producer.write(domain)));
    }

    protected DataFetcher<Collection<ObjectNode>> getDomainModelDataFetcher(String processId) {
        return env -> {
            String query = (String)env.getArgument("query");
            return this.queryService.queryDomain(processId, query);
        };
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.schema;
    }

    public void transform(Consumer<GraphQLSchema.Builder> builder) {
        this.schema = this.schema.transform(builder);
    }
}

