/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.index.cache.Cache;
import org.kie.kogito.index.cache.CacheService;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class IndexingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingService.class);
    private static final String PROCESS_ID = "processId";
    @Inject
    CacheService manager;

    public void indexProcessInstance(ProcessInstance pi) {
        ProcessInstance previousPI = (ProcessInstance)this.manager.getProcessInstancesCache().get((Object)pi.getId());
        if (previousPI != null) {
            List nodes = previousPI.getNodes().stream().filter(n -> !pi.getNodes().contains(n)).collect(Collectors.toList());
            pi.getNodes().addAll(nodes);
        }
        this.manager.getProcessInstancesCache().put((Object)pi.getId(), (Object)pi);
    }

    private String getModelFromProcessId(String processId) {
        return (String)this.manager.getProcessIdModelCache().get((Object)processId);
    }

    public void indexUserTaskInstance(UserTaskInstance ut) {
        this.manager.getUserTaskInstancesCache().put((Object)ut.getId(), (Object)ut);
    }

    public void indexModel(ObjectNode json) {
        String processId = json.get(PROCESS_ID).asText();
        String type = this.getModelFromProcessId(processId);
        if (type == null) {
            LOGGER.debug("Ignoring Kogito cloud event for unknown process: {}", (Object)processId);
            return;
        }
        String processInstanceId = json.get("id").asText();
        Cache cache = this.manager.getDomainModelCache(processId);
        ObjectNode model = (ObjectNode)cache.get(processInstanceId);
        if (model == null) {
            ObjectNode builder = JsonUtils.getObjectMapper().createObjectNode();
            builder.put("_type", type);
            json.remove(PROCESS_ID);
            builder.setAll(json);
            cache.put(processInstanceId, builder);
        } else {
            ArrayNode indexTIArray;
            ObjectNode builder = JsonUtils.getObjectMapper().createObjectNode();
            builder.put("_type", type);
            ArrayNode indexPIArray = (ArrayNode)json.get("processInstances");
            if (indexPIArray != null) {
                json.remove(PROCESS_ID);
                JsonNode id = indexPIArray.get(0).get("id");
                if (processInstanceId.equals(id.asText())) {
                    builder.setAll(json);
                } else {
                    builder.setAll(model);
                    builder.setAll(json);
                }
                ArrayNode utArray = (ArrayNode)model.get("userTasks");
                if (utArray != null) {
                    builder.set("userTasks", (JsonNode)utArray);
                }
                this.copyJsonArray("processInstances", model, builder, indexPIArray);
            }
            if ((indexTIArray = (ArrayNode)json.get("userTasks")) != null) {
                builder.setAll(model);
                this.copyJsonArray("userTasks", model, builder, indexTIArray);
            }
            cache.put(processInstanceId, builder);
        }
    }

    private void copyJsonArray(String attribute, ObjectNode model, ObjectNode builder, ArrayNode arrayNode) {
        ArrayNode arrayBuilder = JsonUtils.getObjectMapper().createArrayNode().addAll(arrayNode);
        ArrayNode jsonArray = model.withArray(attribute);
        if (jsonArray != null) {
            String indexTaskId = arrayNode.get(0).get("id").asText();
            jsonArray.forEach(ti -> {
                if (!indexTaskId.equals(ti.get("id").asText())) {
                    arrayBuilder.add(ti);
                }
            });
        }
        builder.remove(attribute);
        builder.set(attribute, (JsonNode)arrayBuilder);
    }
}

