/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.AccessTokenResponse;
import org.kie.kogito.index.service.KeycloakServer;

@QuarkusTest
@QuarkusTestResource(value=KeycloakServer.class)
public class KeycloakIntegrationIndexingServiceTest {
    private static final String KEYCLOAK_SERVER_URL = System.getProperty("keycloak.url", "http://localhost:8281/auth");
    private static final String KEYCLOAK_REALM = "kogito";
    private static final String KEYCLOAK_CLIENT_ID = "kogito-data-index-service";

    @BeforeAll
    public static void setup() {
        System.setProperty("quarkus.oidc.enabled", "true");
        System.setProperty("quarkus.http.auth.policy.role-policy1.roles-allowed", "confidential");
        System.setProperty("quarkus.http.auth.permission.roles1.paths", "/graphql");
        System.setProperty("quarkus.http.auth.permission.roles1.policy", "role-policy1");
    }

    @Test
    public void testUnauthorizedUserAccess() {
        ((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("alice")).when().get("/graphiql/", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id } }\" }").auth().oauth2(this.getAccessToken("alice")).when().get("/graphql", new Object[0])).then()).statusCode(403);
    }

    @Test
    public void testNoTokenProvided() {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/graphiql/", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id } }\" }").when().get("/graphql", new Object[0])).then()).statusCode(401);
    }

    @Test
    public void testAuthorizedUserProvided() {
        ((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("jdoe")).when().get("/graphiql/", new Object[0])).then()).statusCode(404);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().oauth2(this.getAccessToken("jdoe")).contentType(ContentType.JSON).body("{ \"query\" : \"{ProcessInstances{ id } }\" }").when().post("/graphql", new Object[0])).then()).log().ifValidationFails()).statusCode(200);
    }

    private String getAccessToken(String userName) {
        return ((AccessTokenResponse)((Response)RestAssured.given().param("grant_type", new Object[]{"password"}).param("username", new Object[]{userName}).param("password", new Object[]{userName}).param("client_id", new Object[]{KEYCLOAK_CLIENT_ID}).param("client_secret", new Object[]{"secret"}).when().post(KEYCLOAK_SERVER_URL + "/realms/" + KEYCLOAK_REALM + "/protocol/openid-connect/token", new Object[0])).as(AccessTokenResponse.class)).getToken();
    }
}

