/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.dataloader;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.DeferredFieldInstrumentationContext;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationOptions;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationState;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationDeferredFieldParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetcher;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.stats.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLoaderDispatcherInstrumentation
extends SimpleInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(DataLoaderDispatcherInstrumentation.class);
    private final DataLoaderDispatcherInstrumentationOptions options;

    public DataLoaderDispatcherInstrumentation() {
        this(DataLoaderDispatcherInstrumentationOptions.newOptions());
    }

    public DataLoaderDispatcherInstrumentation(DataLoaderDispatcherInstrumentationOptions options) {
        this.options = options;
    }

    @Override
    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return new DataLoaderDispatcherInstrumentationState(log, parameters.getExecutionInput().getDataLoaderRegistry());
    }

    @Override
    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)parameters.getInstrumentationState();
        if (state.isAggressivelyBatching()) {
            return dataFetcher;
        }
        return environment -> {
            Object obj = dataFetcher.get(environment);
            this.immediatelyDispatch(state);
            return obj;
        };
    }

    private void immediatelyDispatch(DataLoaderDispatcherInstrumentationState state) {
        state.getApproach().dispatch();
    }

    @Override
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters) {
        if (!this.isDataLoaderCompatibleExecution(parameters.getExecutionContext())) {
            DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)parameters.getInstrumentationState();
            state.setAggressivelyBatching(false);
        }
        return new SimpleInstrumentationContext<ExecutionResult>();
    }

    private boolean isDataLoaderCompatibleExecution(ExecutionContext executionContext) {
        ExecutionStrategy queryStrategy;
        return executionContext.getOperationDefinition().getOperation() == OperationDefinition.Operation.QUERY && (queryStrategy = executionContext.getQueryStrategy()) instanceof AsyncExecutionStrategy;
    }

    @Override
    public ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)parameters.getInstrumentationState();
        if (state.hasNoDataLoaders()) {
            return new ExecutionStrategyInstrumentationContext(){

                @Override
                public void onDispatched(CompletableFuture<ExecutionResult> result) {
                }

                @Override
                public void onCompleted(ExecutionResult result, Throwable t) {
                }
            };
        }
        return state.getApproach().beginExecutionStrategy(parameters.withNewState(state.getState()));
    }

    @Override
    public DeferredFieldInstrumentationContext beginDeferredField(InstrumentationDeferredFieldParameters parameters) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)parameters.getInstrumentationState();
        if (state.hasNoDataLoaders()) {
            return new DeferredFieldInstrumentationContext(){

                @Override
                public void onDispatched(CompletableFuture<ExecutionResult> result) {
                }

                @Override
                public void onCompleted(ExecutionResult result, Throwable t) {
                }
            };
        }
        return state.getApproach().beginDeferredField(parameters.withNewState(state.getState()));
    }

    @Override
    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters) {
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)parameters.getInstrumentationState();
        if (state.hasNoDataLoaders()) {
            return new SimpleInstrumentationContext<Object>();
        }
        return state.getApproach().beginFieldFetch(parameters.withNewState(state.getState()));
    }

    @Override
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters) {
        if (!this.options.isIncludeStatistics()) {
            return CompletableFuture.completedFuture(executionResult);
        }
        DataLoaderDispatcherInstrumentationState state = (DataLoaderDispatcherInstrumentationState)parameters.getInstrumentationState();
        Map<Object, Object> currentExt = executionResult.getExtensions();
        LinkedHashMap<Object, Object> statsMap = new LinkedHashMap<Object, Object>();
        statsMap.putAll(currentExt == null ? Collections.emptyMap() : currentExt);
        Map<Object, Object> dataLoaderStats = this.buildStatsMap(state);
        statsMap.put("dataloader", dataLoaderStats);
        log.debug("Data loader stats : {}", (Object)dataLoaderStats);
        return CompletableFuture.completedFuture(new ExecutionResultImpl(executionResult.getData(), executionResult.getErrors(), statsMap));
    }

    private Map<Object, Object> buildStatsMap(DataLoaderDispatcherInstrumentationState state) {
        DataLoaderRegistry dataLoaderRegistry = state.getDataLoaderRegistry();
        Statistics allStats = dataLoaderRegistry.getStatistics();
        LinkedHashMap<Object, Object> statsMap = new LinkedHashMap<Object, Object>();
        statsMap.put("overall-statistics", allStats.toMap());
        LinkedHashMap<String, Map<String, Number>> individualStatsMap = new LinkedHashMap<String, Map<String, Number>>();
        for (String dlKey : dataLoaderRegistry.getKeys()) {
            DataLoader dl = dataLoaderRegistry.getDataLoader(dlKey);
            Statistics statistics = dl.getStatistics();
            individualStatsMap.put(dlKey, statistics.toMap());
        }
        statsMap.put("individual-statistics", individualStatsMap);
        return statsMap;
    }
}

