/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.nextgen.result;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.nextgen.FetchedValueAnalysis;
import graphql.execution.nextgen.result.ExecutionResultNode;
import graphql.execution.nextgen.result.LeafExecutionResultNode;
import graphql.execution.nextgen.result.ListExecutionResultNode;
import graphql.execution.nextgen.result.NamedResultNode;
import graphql.execution.nextgen.result.ObjectExecutionResultNode;
import graphql.execution.nextgen.result.ResultNodeAdapter;
import graphql.execution.nextgen.result.ResultNodeTraverser;
import graphql.execution.nextgen.result.RootExecutionResultNode;
import graphql.execution.nextgen.result.UnresolvedObjectResultNode;
import graphql.util.FpKit;
import graphql.util.NodeLocation;
import graphql.util.NodeMultiZipper;
import graphql.util.NodeZipper;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import graphql.util.TraverserVisitorStub;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
public class ResultNodesUtil {
    public static ExecutionResult toExecutionResult(RootExecutionResultNode root) {
        ExecutionResultData executionResultData = ResultNodesUtil.toDataImpl(root);
        return ExecutionResultImpl.newExecutionResult().data(executionResultData.data).errors(executionResultData.errors).build();
    }

    private static ExecutionResultData data(Object data, ExecutionResultNode executionResultNode) {
        ArrayList<GraphQLError> allErrors = new ArrayList<GraphQLError>();
        allErrors.addAll(executionResultNode.getFetchedValueAnalysis().getErrors());
        allErrors.addAll(executionResultNode.getErrors());
        return new ExecutionResultData(data, allErrors);
    }

    private static ExecutionResultData data(Object data, List<GraphQLError> errors) {
        return new ExecutionResultData(data, errors);
    }

    private static ExecutionResultData data(Object data, NonNullableFieldWasNullException exception) {
        return new ExecutionResultData(data, Arrays.asList(new NonNullableFieldWasNullError(exception)));
    }

    private static ExecutionResultData toDataImpl(ExecutionResultNode root) {
        if (root instanceof LeafExecutionResultNode) {
            return root.getFetchedValueAnalysis().isNullValue() ? ResultNodesUtil.data(null, root) : ResultNodesUtil.data(((LeafExecutionResultNode)root).getValue(), root);
        }
        if (root instanceof ListExecutionResultNode) {
            Optional<NonNullableFieldWasNullException> childNonNullableException = root.getChildNonNullableException();
            if (childNonNullableException.isPresent()) {
                return ResultNodesUtil.data(null, childNonNullableException.get());
            }
            List<ExecutionResultData> list = FpKit.map(root.getChildren(), ResultNodesUtil::toDataImpl);
            List<Object> data = FpKit.map(list, erd -> erd.data);
            ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
            list.forEach(erd -> errors.addAll(erd.errors));
            errors.addAll(root.getErrors());
            return ResultNodesUtil.data(data, errors);
        }
        if (root instanceof UnresolvedObjectResultNode) {
            FetchedValueAnalysis fetchedValueAnalysis = root.getFetchedValueAnalysis();
            return ResultNodesUtil.data((Object)("Not resolved : " + fetchedValueAnalysis.getExecutionStepInfo().getPath() + " with field " + fetchedValueAnalysis.getField()), Collections.emptyList());
        }
        if (root instanceof ObjectExecutionResultNode) {
            Optional<NonNullableFieldWasNullException> childrenNonNullableException = root.getChildNonNullableException();
            if (childrenNonNullableException.isPresent()) {
                return ResultNodesUtil.data(null, childrenNonNullableException.get());
            }
            LinkedHashMap resultMap = new LinkedHashMap();
            ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
            root.getChildren().forEach(child -> {
                ExecutionResultData executionResultData = ResultNodesUtil.toDataImpl(child);
                resultMap.put(child.getMergedField().getResultKey(), executionResultData.data);
                errors.addAll(executionResultData.errors);
            });
            errors.addAll(root.getErrors());
            return ResultNodesUtil.data(resultMap, errors);
        }
        throw new RuntimeException("Unexpected root " + root);
    }

    public static Optional<NonNullableFieldWasNullException> getFirstNonNullableException(Collection<ExecutionResultNode> collection) {
        return collection.stream().filter(executionResultNode -> executionResultNode.getNonNullableFieldWasNullException() != null).map(ExecutionResultNode::getNonNullableFieldWasNullException).findFirst();
    }

    public static NonNullableFieldWasNullException newNullableException(FetchedValueAnalysis fetchedValueAnalysis, List<NamedResultNode> children) {
        return ResultNodesUtil.newNullableException(fetchedValueAnalysis, children.stream().map(NamedResultNode::getNode).collect(Collectors.toList()));
    }

    public static Map<String, ExecutionResultNode> namedNodesToMap(List<NamedResultNode> namedResultNodes) {
        LinkedHashMap<String, ExecutionResultNode> result = new LinkedHashMap<String, ExecutionResultNode>();
        for (NamedResultNode namedResultNode : namedResultNodes) {
            result.put(namedResultNode.getName(), namedResultNode.getNode());
        }
        return result;
    }

    public static NonNullableFieldWasNullException newNullableException(FetchedValueAnalysis fetchedValueAnalysis, Collection<ExecutionResultNode> children) {
        Optional<NonNullableFieldWasNullException> firstNonNullableException;
        if (fetchedValueAnalysis == null) {
            return null;
        }
        Assert.assertNotNull(children);
        boolean listIsNonNull = fetchedValueAnalysis.getExecutionStepInfo().isNonNullType();
        if (listIsNonNull && (firstNonNullableException = ResultNodesUtil.getFirstNonNullableException(children)).isPresent()) {
            return new NonNullableFieldWasNullException(firstNonNullableException.get());
        }
        return null;
    }

    public static List<NodeZipper<ExecutionResultNode>> getUnresolvedNodes(Collection<ExecutionResultNode> roots) {
        final ArrayList<NodeZipper<ExecutionResultNode>> result = new ArrayList<NodeZipper<ExecutionResultNode>>();
        ResultNodeTraverser traverser = ResultNodeTraverser.depthFirst();
        traverser.traverse((TraverserVisitor<ExecutionResultNode>)new TraverserVisitorStub<ExecutionResultNode>(){

            @Override
            public TraversalControl enter(TraverserContext<ExecutionResultNode> context) {
                if (context.thisNode() instanceof UnresolvedObjectResultNode) {
                    result.add(new NodeZipper<ExecutionResultNode>(context.thisNode(), context.getBreadcrumbs(), ResultNodeAdapter.RESULT_NODE_ADAPTER));
                }
                return TraversalControl.CONTINUE;
            }
        }, roots);
        return result;
    }

    public static NodeMultiZipper<ExecutionResultNode> getUnresolvedNodes(ExecutionResultNode root) {
        List unresolvedNodes = ResultNodesUtil.getUnresolvedNodes(Collections.singleton(root));
        return new NodeMultiZipper<ExecutionResultNode>(root, unresolvedNodes, ResultNodeAdapter.RESULT_NODE_ADAPTER);
    }

    public static NodeLocation key(String name) {
        return new NodeLocation(name, 0);
    }

    public static NodeLocation index(int index) {
        return new NodeLocation(null, index);
    }

    private static class ExecutionResultData {
        Object data;
        List<GraphQLError> errors;

        public ExecutionResultData(Object data, List<GraphQLError> errors) {
            this.data = data;
            this.errors = errors;
        }
    }
}

