/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.PublicApi;
import graphql.language.Comment;
import graphql.language.IgnoredChars;
import graphql.language.Node;
import graphql.language.SourceLocation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@PublicApi
public abstract class AbstractNode<T extends Node>
implements Node<T> {
    private final SourceLocation sourceLocation;
    private final List<Comment> comments;
    private final IgnoredChars ignoredChars;
    private final Map<String, String> additionalData;

    public AbstractNode(SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars) {
        this(sourceLocation, comments, ignoredChars, Collections.emptyMap());
    }

    public AbstractNode(SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        Assert.assertNotNull(comments, "comments can't be null", new Object[0]);
        Assert.assertNotNull(ignoredChars, "ignoredChars can't be null", new Object[0]);
        Assert.assertNotNull(additionalData, "additionalData can't be null", new Object[0]);
        this.sourceLocation = sourceLocation;
        this.additionalData = Collections.unmodifiableMap(additionalData);
        this.comments = Collections.unmodifiableList(comments);
        this.ignoredChars = ignoredChars;
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public List<Comment> getComments() {
        return this.comments;
    }

    @Override
    public IgnoredChars getIgnoredChars() {
        return this.ignoredChars;
    }

    @Override
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    protected <V extends Node> V deepCopy(V nullableObj) {
        if (nullableObj == null) {
            return null;
        }
        return (V)nullableObj.deepCopy();
    }

    protected <V extends Node> List<V> deepCopy(List<? extends Node> list) {
        if (list == null) {
            return null;
        }
        return list.stream().map(Node::deepCopy).map(node -> node).collect(Collectors.toList());
    }
}

