/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.PublicApi;
import graphql.util.Breadcrumb;
import graphql.util.NodeAdapter;
import graphql.util.NodeLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@PublicApi
public class NodeZipper<T> {
    private final T curNode;
    private final NodeAdapter<T> nodeAdapter;
    private final List<Breadcrumb<T>> breadcrumbs;
    private final ModificationType modificationType;

    public NodeZipper(T curNode, List<Breadcrumb<T>> breadcrumbs, NodeAdapter<T> nodeAdapter) {
        this(curNode, breadcrumbs, nodeAdapter, ModificationType.REPLACE);
    }

    public NodeZipper(T curNode, List<Breadcrumb<T>> breadcrumbs, NodeAdapter<T> nodeAdapter, ModificationType modificationType) {
        this.curNode = Assert.assertNotNull(curNode);
        this.breadcrumbs = Assert.assertNotNull(breadcrumbs);
        this.nodeAdapter = nodeAdapter;
        this.modificationType = modificationType;
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public T getCurNode() {
        return this.curNode;
    }

    public List<Breadcrumb<T>> getBreadcrumbs() {
        return new ArrayList<Breadcrumb<T>>(this.breadcrumbs);
    }

    public T getParent() {
        return this.breadcrumbs.get(0).getNode();
    }

    public static <T> NodeZipper<T> rootZipper(T rootNode, NodeAdapter<T> nodeAdapter) {
        return new NodeZipper<T>(rootNode, new ArrayList<Breadcrumb<T>>(), nodeAdapter);
    }

    public NodeZipper<T> modifyNode(Function<T, T> transform) {
        return new NodeZipper<T>(transform.apply(this.curNode), this.breadcrumbs, this.nodeAdapter, this.modificationType);
    }

    public NodeZipper<T> deleteNode() {
        return new NodeZipper<T>(this.curNode, this.breadcrumbs, this.nodeAdapter, ModificationType.DELETE);
    }

    public NodeZipper<T> insertAfter(T toInsertAfter) {
        return new NodeZipper<T>(toInsertAfter, this.breadcrumbs, this.nodeAdapter, ModificationType.INSERT_AFTER);
    }

    public NodeZipper<T> insertBefore(T toInsertBefore) {
        return new NodeZipper<T>(toInsertBefore, this.breadcrumbs, this.nodeAdapter, ModificationType.INSERT_BEFORE);
    }

    public NodeZipper<T> withNewNode(T newNode) {
        return new NodeZipper<T>(newNode, this.breadcrumbs, this.nodeAdapter, this.modificationType);
    }

    public NodeZipper<T> moveUp() {
        T node = this.getParent();
        List<Breadcrumb<T>> newBreadcrumbs = this.breadcrumbs.subList(1, this.breadcrumbs.size());
        return new NodeZipper<T>(node, newBreadcrumbs, this.nodeAdapter, this.modificationType);
    }

    public T toRoot() {
        if (this.breadcrumbs.size() == 0 && this.modificationType != ModificationType.DELETE) {
            return this.curNode;
        }
        if (this.breadcrumbs.size() == 0 && this.modificationType == ModificationType.DELETE) {
            return null;
        }
        T curNode = this.curNode;
        Breadcrumb<T> firstBreadcrumb = this.breadcrumbs.get(0);
        Map<String, List<T>> childrenForParent = this.nodeAdapter.getNamedChildren(firstBreadcrumb.getNode());
        NodeLocation locationInParent = firstBreadcrumb.getLocation();
        int ix = locationInParent.getIndex();
        String name = locationInParent.getName();
        switch (this.modificationType) {
            case REPLACE: {
                childrenForParent.get(name).set(ix, curNode);
                break;
            }
            case DELETE: {
                childrenForParent.get(name).remove(ix);
                break;
            }
            case INSERT_BEFORE: {
                childrenForParent.get(name).add(ix, curNode);
                break;
            }
            case INSERT_AFTER: {
                childrenForParent.get(name).add(ix + 1, curNode);
            }
        }
        curNode = this.nodeAdapter.withNewChildren(firstBreadcrumb.getNode(), childrenForParent);
        if (this.breadcrumbs.size() == 1) {
            return curNode;
        }
        for (Breadcrumb<T> breadcrumb : this.breadcrumbs.subList(1, this.breadcrumbs.size())) {
            Map<String, List<T>> newChildren = this.nodeAdapter.getNamedChildren(breadcrumb.getNode());
            T newChild = curNode;
            NodeLocation location = breadcrumb.getLocation();
            newChildren.get(location.getName()).set(location.getIndex(), newChild);
            curNode = this.nodeAdapter.withNewChildren(breadcrumb.getNode(), newChildren);
        }
        return curNode;
    }

    public static enum ModificationType {
        REPLACE,
        DELETE,
        INSERT_AFTER,
        INSERT_BEFORE;

    }
}

