/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.VariableDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

public class VariableDefaultValuesOfCorrectType
extends AbstractRule {
    public VariableDefaultValuesOfCorrectType(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkVariableDefinition(VariableDefinition variableDefinition) {
        String message;
        GraphQLInputType inputType = this.getValidationContext().getInputType();
        if (inputType == null) {
            return;
        }
        if (GraphQLTypeUtil.isNonNull(inputType) && variableDefinition.getDefaultValue() != null) {
            message = "Missing value for non null type";
            this.addError(ValidationErrorType.DefaultForNonNullArgument, variableDefinition.getSourceLocation(), message);
        }
        if (variableDefinition.getDefaultValue() != null && !this.getValidationUtil().isValidLiteralValue(variableDefinition.getDefaultValue(), inputType, this.getValidationContext().getSchema())) {
            message = String.format("Bad default value %s for type %s", variableDefinition.getDefaultValue(), inputType.getName());
            this.addError(ValidationErrorType.BadValueForDefaultArg, variableDefinition.getSourceLocation(), message);
        }
    }
}

