/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.smallrye.config.ConfigSourceMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;

public abstract class AbstractDelegatingConfigSource
implements ConfigSource {
    protected final ConfigSource delegate;
    private Map<String, String> propertiesMap;

    public AbstractDelegatingConfigSource(ConfigSource delegate) {
        Assert.checkNotNullParam("delegate", delegate);
        this.delegate = delegate;
    }

    @NotNull
    protected ConfigSource getDelegate() {
        return this.delegate;
    }

    @Override
    public final Map<String, String> getProperties() {
        ConfigSourceMap propertiesMap = this.propertiesMap;
        if (propertiesMap == null) {
            propertiesMap = this.propertiesMap = new ConfigSourceMap(this);
        }
        return propertiesMap;
    }

    @Override
    public abstract Set<String> getPropertyNames();

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public int getOrdinal() {
        return this.delegate.getOrdinal();
    }
}

