/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ArrayListFactory;
import io.quarkus.runtime.configuration.ConverterClassHolder;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.Converter;

public final class ConfigUtils {
    private static final Map<ConverterClassHolder, Converter<?>> EXPLICIT_RUNTIME_CONVERTERS_CACHE = new HashMap();

    private ConfigUtils() {
    }

    public static <T, C extends Collection<T>> C getDefaults(SmallRyeConfig config, String defaultValue, Class<T> itemType, Class<? extends Converter<T>> converterClass, IntFunction<C> collectionFactory) {
        String[] items = (String[])Arrays.stream(StringUtil.split(defaultValue)).filter(s -> !s.isEmpty()).toArray(String[]::new);
        Collection collection = (Collection)collectionFactory.apply(items.length);
        for (String item : items) {
            if (converterClass == null) {
                collection.add(config.convert(item, itemType));
                continue;
            }
            Converter<T> converter = ConfigUtils.getConverterOfType(itemType, converterClass);
            String rawValue = config.convert(item, String.class);
            collection.add(converter.convert(rawValue));
        }
        return (C)collection;
    }

    public static <T> T getValue(SmallRyeConfig config, String configName, Class<T> objectType, Class<? extends Converter<T>> converterClass) {
        if (converterClass == null) {
            return config.getValue(configName, objectType);
        }
        Converter<T> converter = ConfigUtils.getConverterOfType(objectType, converterClass);
        String rawValue = config.getValue(configName, String.class);
        return converter.convert(rawValue);
    }

    public static <T> Optional<T> getOptionalValue(SmallRyeConfig config, String configName, Class<T> objectType, Class<? extends Converter<T>> converterClass) {
        if (converterClass == null) {
            return config.getOptionalValue(configName, objectType);
        }
        Converter<T> converter = ConfigUtils.getConverterOfType(objectType, converterClass);
        String rawValue = config.getValue(configName, String.class);
        return Optional.ofNullable(converter.convert(rawValue));
    }

    public static <T> ArrayList<T> getValues(SmallRyeConfig config, String configName, Class<T> objectType, Class<? extends Converter<T>> converterClass) {
        if (converterClass == null) {
            return (ArrayList)config.getValues(configName, objectType, ArrayListFactory.getInstance());
        }
        Converter<T> converter = ConfigUtils.getConverterOfType(objectType, converterClass);
        ArrayList rawValues = (ArrayList)config.getValues(configName, String.class, ArrayListFactory.getInstance());
        return rawValues.parallelStream().map(converter::convert).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> T convert(SmallRyeConfig config, String value, Class<T> objectType, Class<? extends Converter<T>> converterClass) {
        if (converterClass == null) {
            return config.convert(value, objectType);
        }
        Converter<T> converter = ConfigUtils.getConverterOfType(objectType, converterClass);
        String rawValue = config.convert(value, String.class);
        return converter.convert(rawValue);
    }

    private static <T> Converter<T> getConverterOfType(Class<T> type, Class<? extends Converter<T>> converterType) {
        Converter<?> converter = EXPLICIT_RUNTIME_CONVERTERS_CACHE.get(new ConverterClassHolder(type, converterType));
        if (converter != null) {
            return converter;
        }
        return ConfigUtils.newConverterInstance(type, converterType);
    }

    public static <T> Converter<T> newConverterInstance(Class<T> type, Class<? extends Converter<T>> converterClass) {
        if (HyphenateEnumConverter.class.equals(converterClass)) {
            HyphenateEnumConverter<T> converter = new HyphenateEnumConverter<T>(type);
            return converter;
        }
        try {
            return converterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void populateExplicitRuntimeConverter(Class<?> typeClass, Class<? extends Converter<?>> converterType, Converter<?> converter) {
        Class<?> type = ConfigUtils.getWrapperClass(typeClass);
        EXPLICIT_RUNTIME_CONVERTERS_CACHE.put(new ConverterClassHolder(type, converterType), converter);
    }

    private static Class<?> getWrapperClass(Class<?> type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return type;
    }
}

