/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class QuarkusIdentityProviderManagerImpl
implements IdentityProviderManager {
    private static final Logger log = Logger.getLogger(QuarkusIdentityProviderManagerImpl.class);
    private final Map<Class<? extends AuthenticationRequest>, List<IdentityProvider>> providers;
    private final List<SecurityIdentityAugmentor> augmenters;
    private final Executor blockingExecutor;
    private final AuthenticationRequestContext blockingRequestContext = new AuthenticationRequestContext(){

        @Override
        public CompletionStage<SecurityIdentity> runBlocking(final Supplier<SecurityIdentity> function) {
            if (BlockingOperationControl.isBlockingAllowed()) {
                CompletableFuture<SecurityIdentity> ret = new CompletableFuture<SecurityIdentity>();
                try {
                    SecurityIdentity result = function.get();
                    ret.complete(result);
                }
                catch (Throwable t) {
                    ret.completeExceptionally(t);
                }
                return ret;
            }
            final CompletableFuture<SecurityIdentity> cf = new CompletableFuture<SecurityIdentity>();
            QuarkusIdentityProviderManagerImpl.this.blockingExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        cf.complete(function.get());
                    }
                    catch (Throwable t) {
                        cf.completeExceptionally(t);
                    }
                }
            });
            return cf;
        }
    };

    QuarkusIdentityProviderManagerImpl(Builder builder) {
        this.providers = builder.providers;
        this.augmenters = builder.augmenters;
        this.blockingExecutor = builder.blockingExecutor;
    }

    @Override
    public CompletionStage<SecurityIdentity> authenticate(AuthenticationRequest request) {
        List providers = this.providers.get(request.getClass());
        if (providers == null) {
            CompletableFuture<SecurityIdentity> cf = new CompletableFuture<SecurityIdentity>();
            cf.completeExceptionally(new IllegalArgumentException("No IdentityProviders were registered to handle AuthenticationRequest " + request));
            return cf;
        }
        return this.handleProvider(0, providers, request, this.blockingRequestContext);
    }

    @Override
    public SecurityIdentity authenticateBlocking(AuthenticationRequest request) {
        List providers = this.providers.get(request.getClass());
        if (providers == null) {
            throw new IllegalArgumentException("No IdentityProviders were registered to handle AuthenticationRequest " + request);
        }
        return this.handleProvider(0, providers, request, this.blockingRequestContext).toCompletableFuture().join();
    }

    private <T extends AuthenticationRequest> CompletionStage<SecurityIdentity> handleProvider(final int pos, final List<IdentityProvider<T>> providers, final T request, final AuthenticationRequestContext context) {
        if (pos == providers.size()) {
            log.debug("Authentication failed as providers would authenticate the request");
            CompletableFuture<SecurityIdentity> cf = new CompletableFuture<SecurityIdentity>();
            cf.completeExceptionally(new AuthenticationFailedException());
            return cf;
        }
        IdentityProvider<T> current = providers.get(pos);
        CompletionStage<SecurityIdentity> cs = current.authenticate(request, context).thenCompose(new Function<SecurityIdentity, CompletionStage<SecurityIdentity>>(){

            @Override
            public CompletionStage<SecurityIdentity> apply(SecurityIdentity identity) {
                if (identity != null) {
                    return CompletableFuture.completedFuture(identity);
                }
                return QuarkusIdentityProviderManagerImpl.this.handleProvider(pos + 1, providers, request, context);
            }
        });
        return cs.thenCompose(new Function<SecurityIdentity, CompletionStage<SecurityIdentity>>(){

            @Override
            public CompletionStage<SecurityIdentity> apply(SecurityIdentity identity) {
                return QuarkusIdentityProviderManagerImpl.this.handleIdentityFromProvider(0, identity, context);
            }
        });
    }

    private CompletionStage<SecurityIdentity> handleIdentityFromProvider(final int pos, SecurityIdentity identity, final AuthenticationRequestContext context) {
        if (pos == this.augmenters.size()) {
            return CompletableFuture.completedFuture(identity);
        }
        SecurityIdentityAugmentor a = this.augmenters.get(pos);
        return a.augment(identity, context).thenCompose(new Function<SecurityIdentity, CompletionStage<SecurityIdentity>>(){

            @Override
            public CompletionStage<SecurityIdentity> apply(SecurityIdentity identity) {
                return QuarkusIdentityProviderManagerImpl.this.handleIdentityFromProvider(pos + 1, identity, context);
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Class<? extends AuthenticationRequest>, List<IdentityProvider>> providers = new HashMap<Class<? extends AuthenticationRequest>, List<IdentityProvider>>();
        private final List<SecurityIdentityAugmentor> augmenters = new ArrayList<SecurityIdentityAugmentor>();
        private Executor blockingExecutor;
        private boolean built = false;

        Builder() {
        }

        public Builder addProvider(IdentityProvider provider) {
            if (this.built) {
                throw new IllegalStateException("manager has already been built");
            }
            this.providers.computeIfAbsent(provider.getRequestType(), a -> new ArrayList()).add(provider);
            return this;
        }

        public Builder addSecurityIdentityAugmenter(SecurityIdentityAugmentor augmentor) {
            this.augmenters.add(augmentor);
            return this;
        }

        public Builder setBlockingExecutor(Executor blockingExecutor) {
            this.blockingExecutor = blockingExecutor;
            return this;
        }

        public QuarkusIdentityProviderManagerImpl build() {
            this.built = true;
            if (!this.providers.containsKey(AnonymousAuthenticationRequest.class)) {
                throw new IllegalStateException("No AnonymousIdentityProvider registered. An instance of AnonymousIdentityProvider must be provided to allow the Anonymous identity to be created.");
            }
            if (this.blockingExecutor == null) {
                throw new IllegalStateException("no blocking executor specified");
            }
            this.augmenters.sort(new Comparator<SecurityIdentityAugmentor>(){

                @Override
                public int compare(SecurityIdentityAugmentor o1, SecurityIdentityAugmentor o2) {
                    return Integer.compare(o2.priority(), o1.priority());
                }
            });
            return new QuarkusIdentityProviderManagerImpl(this);
        }
    }
}

