/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor.check;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.interceptor.check.SecurityCheck;
import java.util.Set;

public class RolesAllowedCheck
implements SecurityCheck {
    private final String[] allowedRoles;

    public RolesAllowedCheck(String[] allowedRoles) {
        this.allowedRoles = allowedRoles;
    }

    @Override
    public void apply(SecurityIdentity identity) {
        Set<String> roles = identity.getRoles();
        if (roles != null) {
            for (String role : this.allowedRoles) {
                if (!roles.contains(role)) continue;
                return;
            }
        }
        if (identity.isAnonymous()) {
            throw new UnauthorizedException();
        }
        throw new ForbiddenException();
    }
}

