/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.PolicyMappingConfig;
import io.quarkus.vertx.http.runtime.security.DenySecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PathMatcher;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.inject.Singleton;

@Singleton
public class PathMatchingHttpSecurityPolicy
implements HttpSecurityPolicy {
    private final PathMatcher<List<HttpMatcher>> pathMatcher = new PathMatcher();

    @Override
    public CompletionStage<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext routingContext, SecurityIdentity identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        CompletableFuture<HttpSecurityPolicy.CheckResult> latch = new CompletableFuture<HttpSecurityPolicy.CheckResult>();
        List<HttpSecurityPolicy> permissionCheckers = this.findPermissionCheckers(routingContext.request());
        this.doPermissionCheck(routingContext, latch, identity, 0, permissionCheckers, requestContext);
        return latch;
    }

    private void doPermissionCheck(final RoutingContext routingContext, final CompletableFuture<HttpSecurityPolicy.CheckResult> latch, final SecurityIdentity identity, final int index, final List<HttpSecurityPolicy> permissionCheckers, final HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        if (index == permissionCheckers.size()) {
            latch.complete(new HttpSecurityPolicy.CheckResult(true, identity));
            return;
        }
        HttpSecurityPolicy res = permissionCheckers.get(index);
        res.checkPermission(routingContext, identity, requestContext).handle(new BiFunction<HttpSecurityPolicy.CheckResult, Throwable, Object>(){

            @Override
            public Object apply(HttpSecurityPolicy.CheckResult checkResult, Throwable throwable) {
                if (throwable != null) {
                    latch.completeExceptionally(throwable);
                } else if (!checkResult.isPermitted()) {
                    latch.complete(HttpSecurityPolicy.CheckResult.DENY);
                } else {
                    SecurityIdentity newIdentity = checkResult.getAugmentedIdentity() != null ? checkResult.getAugmentedIdentity() : identity;
                    PathMatchingHttpSecurityPolicy.this.doPermissionCheck(routingContext, latch, newIdentity, index + 1, permissionCheckers, requestContext);
                }
                return null;
            }
        });
    }

    void init(HttpBuildTimeConfig config, Map<String, Supplier<HttpSecurityPolicy>> supplierMap) {
        HashMap<String, HttpSecurityPolicy> permissionCheckers = new HashMap<String, HttpSecurityPolicy>();
        for (Map.Entry<String, Supplier<HttpSecurityPolicy>> i : supplierMap.entrySet()) {
            permissionCheckers.put(i.getKey(), i.getValue().get());
        }
        HashMap tempMap = new HashMap();
        for (Map.Entry<String, PolicyMappingConfig> entry : config.auth.permissions.entrySet()) {
            HttpSecurityPolicy checker = (HttpSecurityPolicy)permissionCheckers.get(entry.getValue().policy);
            if (checker == null) {
                throw new RuntimeException("Unable to find HTTP security policy " + entry.getValue().policy);
            }
            for (String path : entry.getValue().paths) {
                HttpMatcher m;
                if (tempMap.containsKey(path)) {
                    m = new HttpMatcher(new HashSet<String>(entry.getValue().methods), checker);
                    ((List)tempMap.get(path)).add(m);
                    continue;
                }
                m = new HttpMatcher(new HashSet<String>(entry.getValue().methods), checker);
                ArrayList<HttpMatcher> perms = new ArrayList<HttpMatcher>();
                tempMap.put(path, perms);
                perms.add(m);
                if (path.endsWith("/*")) {
                    String stripped = path.substring(0, path.length() - 2);
                    this.pathMatcher.addPrefixPath(stripped.isEmpty() ? "/" : stripped, perms);
                    continue;
                }
                if (path.endsWith("*")) {
                    this.pathMatcher.addPrefixPath(path.substring(0, path.length() - 1), perms);
                    continue;
                }
                this.pathMatcher.addExactPath(path, perms);
            }
        }
    }

    public List<HttpSecurityPolicy> findPermissionCheckers(HttpServerRequest request) {
        PathMatcher.PathMatch<List<HttpMatcher>> toCheck = this.pathMatcher.match(request.path());
        if (toCheck.getValue() == null || toCheck.getValue().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HttpSecurityPolicy> methodMatch = new ArrayList<HttpSecurityPolicy>();
        ArrayList<HttpSecurityPolicy> noMethod = new ArrayList<HttpSecurityPolicy>();
        for (HttpMatcher i : toCheck.getValue()) {
            if (i.methods == null || i.methods.isEmpty()) {
                noMethod.add(i.checker);
                continue;
            }
            if (!i.methods.contains(request.method().toString())) continue;
            methodMatch.add(i.checker);
        }
        if (!methodMatch.isEmpty()) {
            return methodMatch;
        }
        if (!noMethod.isEmpty()) {
            return noMethod;
        }
        return Collections.singletonList(DenySecurityPolicy.INSTANCE);
    }

    static class HttpMatcher {
        final Set<String> methods;
        final HttpSecurityPolicy checker;

        HttpMatcher(Set<String> methods, HttpSecurityPolicy checker) {
            this.methods = methods;
            this.checker = checker;
        }
    }
}

