/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.SmallRyeContextManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.eclipse.microprofile.context.spi.ContextManagerProviderRegistration;

public class SmallRyeContextManagerProvider
implements ContextManagerProvider {
    private static ContextManagerProviderRegistration registration;
    private Map<ClassLoader, ContextManager> contextManagersForClassLoader = new HashMap<ClassLoader, ContextManager>();

    @Deprecated
    public static void register() {
        if (registration == null) {
            registration = ContextManagerProvider.register(new SmallRyeContextManagerProvider());
        }
    }

    @Deprecated
    public static void unregister() {
        registration.unregister();
        registration = null;
    }

    @Override
    public ContextManager getContextManager() {
        return this.getContextManager(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContextManager getContextManager(ClassLoader classLoader) {
        ContextManager config = this.contextManagersForClassLoader.get(classLoader);
        if (config == null) {
            SmallRyeContextManagerProvider smallRyeContextManagerProvider = this;
            synchronized (smallRyeContextManagerProvider) {
                config = this.contextManagersForClassLoader.get(classLoader);
                if (config == null) {
                    config = this.getContextManagerBuilder().forClassLoader(classLoader).addDiscoveredThreadContextProviders().addDiscoveredContextManagerExtensions().build();
                    this.registerContextManager(config, classLoader);
                }
            }
        }
        return config;
    }

    @Override
    public SmallRyeContextManager.Builder getContextManagerBuilder() {
        return new SmallRyeContextManager.Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContextManager(ContextManager manager, ClassLoader classLoader) {
        SmallRyeContextManagerProvider smallRyeContextManagerProvider = this;
        synchronized (smallRyeContextManagerProvider) {
            this.contextManagersForClassLoader.put(classLoader, manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseContextManager(ContextManager manager) {
        SmallRyeContextManagerProvider smallRyeContextManagerProvider = this;
        synchronized (smallRyeContextManagerProvider) {
            Iterator<Map.Entry<ClassLoader, ContextManager>> iterator = this.contextManagersForClassLoader.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ClassLoader, ContextManager> entry = iterator.next();
                if (entry.getValue() != manager) continue;
                iterator.remove();
                return;
            }
        }
    }

    public static SmallRyeContextManager getManager() {
        return (SmallRyeContextManager)ContextManagerProvider.instance().getContextManager();
    }
}

