/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.propagators.rxjava2;

import io.reactivex.Flowable;
import io.reactivex.functions.BiFunction;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ContextPropagatorOnFlowableCreateAction
implements BiFunction<Flowable, Subscriber, Subscriber> {
    private ThreadContext threadContext;

    public ContextPropagatorOnFlowableCreateAction(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    @Override
    public Subscriber apply(Flowable flowable, Subscriber observer) throws Exception {
        return new ContextCapturerFlowable(flowable, observer, this.threadContext.currentContextExecutor());
    }

    public class ContextCapturerFlowable<T>
    implements Subscriber<T> {
        private final Subscriber<T> source;
        private final Executor contextExecutor;

        public ContextCapturerFlowable(Flowable<T> observable, Subscriber<T> observer, Executor contextExecutor) {
            this.source = observer;
            this.contextExecutor = contextExecutor;
        }

        @Override
        public void onComplete() {
            this.contextExecutor.execute(() -> this.source.onComplete());
        }

        @Override
        public void onError(Throwable t) {
            this.contextExecutor.execute(() -> this.source.onError(t));
        }

        @Override
        public void onNext(T v) {
            this.contextExecutor.execute(() -> this.source.onNext(v));
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.contextExecutor.execute(() -> this.source.onSubscribe(s));
        }
    }
}

