/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.jwt.ClaimValue;

public class ClaimValueWrapper<T>
implements ClaimValue<T> {
    private final CommonJwtProducer producer;
    private final String name;
    private final boolean optional;

    public ClaimValueWrapper(InjectionPoint ip, CommonJwtProducer producer) {
        this.producer = producer;
        this.name = producer.getName(ip);
        Type injectedType = ip.getType();
        if (injectedType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)injectedType;
            Type typeArgument = parameterizedType.getActualTypeArguments()[0];
            this.optional = typeArgument.getTypeName().startsWith(Optional.class.getTypeName());
        } else {
            this.optional = false;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getValue() {
        Object value = this.producer.getValue(this.getName(), this.optional);
        if (this.optional) {
            return (T)Optional.ofNullable(value);
        }
        return value;
    }

    @Override
    public String toString() {
        T value = this.getValue();
        return String.format("ClaimValueWrapper[@%s], name=%s, value[%s]=%s", Integer.toHexString(this.hashCode()), this.name, value.getClass(), value);
    }
}

