/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.mechanism;

import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import java.security.Principal;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@ApplicationScoped
public class JWTHttpAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static Logger logger = Logger.getLogger(JWTHttpAuthenticationMechanism.class);
    @Inject
    private JWTAuthContextInfo authContextInfo;
    @Inject
    private PrincipalProducer producer;

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        BearerTokenExtractor extractor = new BearerTokenExtractor(request, this.authContextInfo);
        String bearerToken = extractor.getBearerToken();
        if (bearerToken != null) {
            try {
                JsonWebToken jwtPrincipal = extractor.validate(bearerToken);
                this.producer.setJsonWebToken(jwtPrincipal);
                Set<String> groups = jwtPrincipal.getGroups();
                logger.debugf("Success", new Object[0]);
                return httpMessageContext.notifyContainerAboutLogin((Principal)jwtPrincipal, groups);
            }
            catch (Exception e) {
                logger.warnf((Throwable)e, "Unable to validate bearer token: %s", (Object)e.getMessage());
                return httpMessageContext.responseUnauthorized();
            }
        }
        logger.debug("No usable bearer token was found in the request, continuing unauthenticated");
        return httpMessageContext.doNothing();
    }

    private static class BearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private final HttpServletRequest request;

        BearerTokenExtractor(HttpServletRequest request, JWTAuthContextInfo authContextInfo) {
            super(authContextInfo);
            this.request = request;
        }

        @Override
        protected String getHeaderValue(String headerName) {
            return this.request.getHeader(headerName);
        }

        @Override
        protected String getCookieValue(String cookieName) {
            Cookie[] cookies = this.request.getCookies();
            Cookie tokenCookie = null;
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookieName.equals(cookie.getName())) continue;
                    tokenCookie = cookie;
                    break;
                }
            }
            if (tokenCookie != null) {
                return tokenCookie.getValue();
            }
            return null;
        }
    }
}

